% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_max_flag.R
\name{max_flag}
\alias{max_flag}
\title{Creating Maximum Flag}
\usage{
max_flag(dataset, by_vars, fl)
}
\arguments{
\item{dataset}{Input dataset}

\item{by_vars}{By variables which goes to group by, to create the flag. Pass the variables
inside the exprs().}

\item{fl}{Flag variable name, Pass it as string.}
}
\value{
Data frame with flag variable which is flagged for the maximum value records depending on
the variables passed in \code{by_vars} by user.
}
\description{
To Flag the maximum records depends on the grouping variables in a flag variable.
}
\examples{

library(tibble)
library(admiral)

input <- tribble(
  ~USUBJID, ~FAOBJ, ~FATESTCD, ~FATPTREF, ~AVAL, ~FATPT, ~PARAMCD,
  "ABC101", "REDNESS", "DIAMETER", "VACC 1", 10, "DAY 1", "DIARE",
  "ABC101", "REDNESS", "DIAMETER", "VACC 1", 7, "DAY 2", "DIARE",
  "ABC101", "REDNESS", "DIAMETER", "VACC 2", 3, "DAY 1", "DIARE",
  "ABC101", "REDNESS", "DIAMETER", "VACC 2", 8, "DAY 2", "DIARE",
  "ABC101", "FATIQUE", "SEV", "VACC 1", 1, "DAY 1", "SEVFAT",
  "ABC101", "FATIQUE", "SEV", "VACC 1", 1, "DAY 2", "SEVFAT",
  "ABC101", "FATIQUE", "SEV", "VACC 2", 2, "DAY 1", "SEVFAT",
  "ABC101", "FATIQUE", "SEV", "VACC 2", 3, "DAY 2", "SEVFAT"
)

max_flag(
  dataset = input,
  by_vars = exprs(USUBJID, FAOBJ, FATPTREF, PARAMCD),
  fl = "ANL01FL"
)

}
\author{
Dhivya Kanagaraj
}
\concept{utils_help}
\keyword{utils_help}
