% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_sources.R
\docType{data}
\name{rsp_y}
\alias{rsp_y}
\alias{no_data_n}
\alias{cb_y}
\alias{bor_cr}
\alias{bor_pr}
\alias{bor_sd}
\alias{bor_non_crpd}
\alias{bor_pd}
\alias{bor_ne}
\alias{no_data_missing}
\alias{crsp_y_cr}
\alias{crsp_y_pr}
\alias{cbor_cr}
\alias{cbor_pr}
\title{Pre-Defined Response Event Objects}
\usage{
rsp_y

no_data_n

cb_y

bor_cr

bor_pr

bor_sd

bor_non_crpd

bor_pd

bor_ne

no_data_missing

crsp_y_cr

crsp_y_pr

cbor_cr

cbor_pr
}
\description{
These pre-defined \code{event()} and \code{event_joined()} objects can be used as input
to \code{admiral::derive_extreme_event()}.
}
\details{
To see the definition of the various objects simply print the object in the
R console, e.g. \code{bor_sd}. For details of how to use these objects
please refer to \code{\link[admiral:derive_extreme_event]{admiral::derive_extreme_event()}}.

It is assumed that \code{dataset_name = "ovr"} refers to the dataset of the only
overall response assessments at each visit which should be considered for the
parameter derivations. For example the dataset should include only
post-baseline assessments up to first PD and before start of anti-cancer
therapy.
}
\examples{
# This shows the definition of all pre-defined `event` objects that ship
# with {admiralonco}
exports <- sort(getNamespaceExports("admiralonco"))
for (obj_name in exports) {
  obj <- getExportedValue("admiralonco", obj_name)
  if (inherits(obj, "event_def")) {
    cat("\n", obj_name, ":\n", sep = "")
    print(obj, indent = 2)
  }
}
}
\seealso{
\code{\link[admiral:derive_extreme_event]{admiral::derive_extreme_event()}}, \code{\link[admiral:event]{admiral::event()}}, \code{\link[admiral:event_joined]{admiral::event_joined()}}
}
\keyword{source_specifications}
