% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_logical_scalar}
\alias{assert_logical_scalar}
\title{Is an Argument a Logical Scalar (Boolean)?}
\usage{
assert_logical_scalar(arg, optional = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{optional}{Is the checked parameter optional?

If set to \code{FALSE} and \code{arg} is \code{NULL} then an error is thrown. Otherwise,
\code{NULL} is considered as valid value.}
}
\value{
The function throws an error if \code{arg} is neither \code{TRUE} or \code{FALSE}. Otherwise,
the input is returned invisibly.
}
\description{
Checks if an argument is a logical scalar
}
\examples{
example_fun <- function(flag) {
  assert_logical_scalar(flag)
}

example_fun(FALSE)

try(example_fun(NA))

try(example_fun(c(TRUE, FALSE, FALSE)))

try(example_fun(1:10))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_function}()},
\code{\link{assert_has_variables}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_named_exprs}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_order_vars}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\author{
Thomas Neitmann, Stefan Bundfuss
}
\concept{assertion}
\keyword{assertion}
