% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{replace_symbol_in_quo}
\alias{replace_symbol_in_quo}
\title{Replace Symbols in a Quosure}
\usage{
replace_symbol_in_quo(quosure, target, replace)
}
\arguments{
\item{quosure}{Quosure}

\item{target}{Target symbol}

\item{replace}{Replacing symbol}
}
\value{
The quosure where every occurence of the symbol \code{target} is replaced
by \code{replace}
}
\description{
Replace symbols in a quosure
}
\examples{

library(rlang)

replace_symbol_in_quo(quo(AVAL), target = AVAL, replace = AVAL.join)
replace_symbol_in_quo(quo(AVALC), target = AVAL, replace = AVAL.join)
replace_symbol_in_quo(quo(desc(AVAL)), target = AVAL, replace = AVAL.join)
}
\seealso{
Helpers for working with Quosures: 
\code{\link{add_suffix_to_vars}()},
\code{\link{quo_c}()},
\code{\link{quo_not_missing}()},
\code{\link{replace_values_by_names}()}
}
\author{
Stefan Bundfuss
}
\concept{quo}
\keyword{quo}
