% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev_utilities.R
\name{negate_vars}
\alias{negate_vars}
\title{Negate List of Variables}
\usage{
negate_vars(vars = NULL)
}
\arguments{
\item{vars}{List of variables created by \code{vars()}}
}
\value{
A list of \code{quosures}
}
\description{
The function adds a minus sign as prefix to each variable.
}
\details{
This is useful if a list of variables should be removed from a dataset,
e.g., \code{select(!!!negate_vars(by_vars))} removes all by variables.
}
\examples{
negate_vars(vars(USUBJID, STUDYID))
}
\seealso{
Developer Utility Functions: 
\code{\link{\%notin\%}()},
\code{\link{\%or\%}()},
\code{\link{arg_name}()},
\code{\link{as_name}()},
\code{\link{convert_dtm_to_dtc}()},
\code{\link{extract_vars}()},
\code{\link{filter_if}()},
\code{\link{replace_values_by_names}()},
\code{\link{valid_time_units}()},
\code{\link{vars2chr}()}
}
\author{
Stefan Bundfuss
}
\concept{dev_utility}
\keyword{dev_utility}
