% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dt_dtm_utils.R
\name{get_imputation_target_date}
\alias{get_imputation_target_date}
\title{Get Date Imputation Targets}
\usage{
get_imputation_target_date(date_imputation, month)
}
\arguments{
\item{date_imputation}{The value to impute the day/month when a datepart is
missing.

A character value is expected, either as a
\itemize{
\item format with month and day specified as \code{"mm-dd"}: e.g. \code{"06-15"} for the 15th
of June,
\item or as a keyword: \code{"first"}, \code{"mid"}, \code{"last"} to impute to the first/mid/last
day/month.
}}

\item{month}{Month component of the partial date}
}
\value{
A list of character vectors. The elements of the list are named
"year", "month", "day".
}
\description{
Get Date Imputation Targets
}
\details{
\itemize{
\item For \code{date_imputation = "first"} \code{"0000"}, \code{"01"}, \code{"01"} are returned.
\item For \code{date_imputation = "mid"} \code{"xxxx"}, \code{"06"}, \code{"30"} if \code{month} is \code{NA}
and \code{"15"} otherwise are returned.
\item For \code{date_imputation = "last"} \code{"9999"}, \code{"12"}, \code{"31"} are returned.
\item For \code{date_imputation = "<mm>-<dd>"} \code{"xxxx"}, \code{"<mm>"}, \code{"<dd>"} are returned.
}

\code{"xxxx"} indicates that the component is undefined. If an undefined
component occurs in the imputed DTC value, the imputed DTC value is set to
\code{NA_character_} in the imputation functions.
}
\seealso{
\code{\link[=impute_dtc_dtm]{impute_dtc_dtm()}}, \code{\link[=impute_dtc_dt]{impute_dtc_dt()}}

Utilities used for date imputation: 
\code{\link{dt_level}()},
\code{\link{dtm_level}()},
\code{\link{get_imputation_target_time}()},
\code{\link{get_partialdatetime}()},
\code{\link{restrict_imputed_dtc_dt}()},
\code{\link{restrict_imputed_dtc_dtm}()}
}
\concept{utils_impute}
\keyword{internal}
