% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_disposition_reason.R
\name{derive_vars_disposition_reason}
\alias{derive_vars_disposition_reason}
\title{Derive a Disposition Reason at a Specific Timepoint}
\usage{
derive_vars_disposition_reason(
  dataset,
  dataset_ds,
  new_var,
  reason_var,
  new_var_spe = NULL,
  reason_var_spe = NULL,
  format_new_vars = format_reason_default,
  filter_ds,
  subject_keys = get_admiral_option("subject_keys")
)
}
\arguments{
\item{dataset}{Input dataset}

\item{dataset_ds}{Dataset containing the disposition information (e.g. \code{ds})

The dataset must contain:
\itemize{
\item \code{STUDYID}, \code{USUBJID},
\item The variable(s) specified in the \code{reason_var} (and \code{reason_var_spe}, if required)
\item The variables used in \code{filter_ds}.
}}

\item{new_var}{Name of the disposition reason variable

A variable name is expected (e.g. \code{DCSREAS}).}

\item{reason_var}{The variable used to derive the disposition reason

A variable name is expected (e.g. \code{DSDECOD}).}

\item{new_var_spe}{Name of the disposition reason detail variable

A variable name is expected (e.g. \code{DCSREASP}).
If \code{new_var_spe} is specified, it is expected that \code{reason_var_spe} is also specified,
otherwise an error is issued.

Default: NULL}

\item{reason_var_spe}{The variable used to derive the disposition reason detail

A variable name is expected (e.g. \code{DSTERM}).
If \code{new_var_spe} is specified, it is expected that \code{reason_var_spe} is also specified,
otherwise an error is issued.

Default: NULL}

\item{format_new_vars}{The function used to derive the reason(s)

This function is used to derive the disposition reason(s) and must follow the below conventions
\itemize{
\item If only the main reason for discontinuation needs to be derived (i.e. \code{new_var_spe} is NULL),
the function must have at least one character vector argument, e.g.
\verb{format_reason <- function(reason)}
and \code{new_var} will be derived as \code{new_var = format_reason(reason_var)}.
Typically, the content of the function would return \code{reason_var} or \code{NA} depending on the
value (e.g. \code{if_else ( reason != "COMPLETED" & !is.na(reason), reason, NA_character_)}).
\code{DCSREAS = format_reason(DSDECOD)} returns \code{DCSREAS = DSDECOD}
when \code{DSDECOD} is not \code{'COMPLETED'} nor \code{NA}, \code{NA} otherwise.
\item If both the main reason and the details needs to be derived (\code{new_var_spe} is specified)
the function must have two character vectors argument, e.g.
\verb{format_reason2 <- function(reason, reason_spe)} and
\code{new_var} will be derived as \code{new_var = format_reason(reason_var)},
\code{new_var_spe} will be derived as \code{new_var_spe = format_reason(reason_var, reason_var_spe)}.
Typically, the content of the function would return \code{reason_var_spe} or \code{NA} depending on the
\code{reason_var} value (e.g. \code{if_else ( reason == "OTHER", reason_spe, NA_character_)}).
\code{DCSREASP = format_reason(DSDECOD, DSTERM)} returns \code{DCSREASP = DSTERM} when
\code{DSDECOD} is equal to \code{'OTHER'}.
}

Default: \code{format_reason_default}, see \code{\link[=format_reason_default]{format_reason_default()}} for details.}

\item{filter_ds}{Filter condition for the disposition data.

Filter used to select the relevant disposition data.
It is expected that the filter restricts \code{dataset_ds} such that there is at most
one observation per patient. An error is issued otherwise.

Permitted Values: logical expression.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of quosures where the expressions are symbols as returned by
\code{vars()} is expected.}
}
\value{
the input dataset with the disposition reason(s) (\code{new_var} and
if required \code{new_var_spe}) added.
}
\description{
Derive a disposition reason from the the relevant records in the disposition domain.
}
\details{
This functions returns the main reason for discontinuation (e.g. \code{DCSREAS} or \code{DCTREAS}).
The reason for discontinuation is derived based on \code{reason_var} (e.g. \code{DSDECOD}) and
\code{format_new_vars}.
If \code{new_var_spe} is not NULL, then the function will also return the details associated
with the reason for discontinuation (e.g. \code{DCSREASP}).
The details associated with the reason for discontinuation are derived based on
\code{reason_var_spe} (e.g. \code{DSTERM}), \code{reason_var} and \code{format_new_vars}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data("admiral_dm")
data("admiral_ds")

# Derive DCSREAS using the default format
admiral_dm \%>\%
  derive_vars_disposition_reason(
    dataset_ds = admiral_ds,
    new_var = DCSREAS,
    reason_var = DSDECOD,
    filter_ds = DSCAT == "DISPOSITION EVENT"
  ) \%>\%
  select(STUDYID, USUBJID, DCSREAS)

# Derive DCSREAS and DCSREASP using a study-specific format
format_dcsreas <- function(x, y = NULL) {
  if (is.null(y)) {
    if_else(!x \%in\% c("COMPLETED", "SCREEN FAILURE") & !is.na(x), x, NA_character_)
  } else {
    if_else(x == "OTHER", y, NA_character_)
  }
}
admiral_dm \%>\%
  derive_vars_disposition_reason(
    dataset_ds = admiral_ds,
    new_var = DCSREAS,
    reason_var = DSDECOD,
    new_var_spe = DCSREASP,
    reason_var_spe = DSTERM,
    format_new_vars = format_dcsreas,
    filter_ds = DSCAT == "DISPOSITION EVENT"
  ) \%>\%
  select(STUDYID, USUBJID, DCSREAS, DCSREASP)
}
\seealso{
\code{\link[=format_reason_default]{format_reason_default()}}

ADSL Functions that returns variable appended to dataset: 
\code{\link{derive_var_age_years}()},
\code{\link{derive_var_disposition_status}()},
\code{\link{derive_var_dthcaus}()},
\code{\link{derive_var_extreme_dtm}()},
\code{\link{derive_var_extreme_dt}()},
\code{\link{derive_vars_aage}()},
\code{\link{derive_vars_period}()}
}
\author{
Samia Kabi
}
\concept{der_adsl}
\keyword{der_adsl}
