% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_merged.R
\name{derive_var_merged_summary}
\alias{derive_var_merged_summary}
\title{Merge a Summary Variable}
\usage{
derive_var_merged_summary(
  dataset,
  dataset_add,
  by_vars,
  new_var,
  filter_add = NULL,
  analysis_var,
  summary_fun
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected.}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars} and the \code{analysis_var} arguments
are expected.}

\item{by_vars}{Grouping variables

The values of \code{analysis_var} are summarized by the specified variables. The
summarized values are merged to the input dataset (\code{dataset}) by the
specified by variables.

\emph{Permitted Values}: list of variables created by \code{vars()}}

\item{new_var}{Variable to add

The specified variable is added to the input dataset (\code{dataset}) and set to
the summarized values.}

\item{filter_add}{Filter for additional dataset (\code{dataset_add})

Only observations fulfilling the specified condition are taken into account
for summarizing. If the argument is not specified, all observations are
considered.

\emph{Permitted Values}: a condition}

\item{analysis_var}{Analysis variable

The values of the specified variable are summarized by the function
specified for \code{summary_fun}.}

\item{summary_fun}{Summary function

The specified function that takes as input \code{analysis_var} and performs the
calculation. This can include built-in functions as well as user defined
functions, for example \code{mean} or \code{function(x) mean(x, na.rm = TRUE)}.}
}
\value{
The output dataset contains all observations and variables of the
input dataset and additionally the variable specified for \code{new_var}.
}
\description{
Merge a summary variable from a dataset to the input dataset.
}
\details{
\enumerate{
\item The records from the additional dataset (\code{dataset_add}) are restricted
to those matching the \code{filter_add} condition.
\item The values of the analysis variable (\code{analysis_var}) are summarized by
the summary function (\code{summary_fun}) for each by group (\code{by_vars}) in the
additional dataset (\code{dataset_add}).
\item The summarized values are merged to the input dataset as a new variable
(\code{new_var}). For observations without a matching observation in the
additional dataset the new variable is set to \code{NA}. Observations in the
additional dataset which have no matching observation in the input dataset
are ignored.
}
}
\examples{
library(tibble)

# Add a variable for the mean of AVAL within each visit
adbds <- tribble(
  ~USUBJID, ~AVISIT,  ~ASEQ, ~AVAL,
  "1",      "WEEK 1",     1,    10,
  "1",      "WEEK 1",     2,    NA,
  "1",      "WEEK 2",     3,    NA,
  "1",      "WEEK 3",     4,    42,
  "1",      "WEEK 4",     5,    12,
  "1",      "WEEK 4",     6,    12,
  "1",      "WEEK 4",     7,    15,
  "2",      "WEEK 1",     1,    21,
  "2",      "WEEK 4",     2,    22
)

derive_var_merged_summary(
  adbds,
  dataset_add = adbds,
  by_vars = vars(USUBJID, AVISIT),
  new_var = MEANVIS,
  analysis_var = AVAL,
  summary_fun = function(x) mean(x, na.rm = TRUE)
)

# Add a variable listing the lesion ids at baseline
adsl <- tribble(
  ~USUBJID,
  "1",
  "2",
  "3"
)

adtr <- tribble(
  ~USUBJID, ~AVISIT,    ~LESIONID,
  "1",      "BASELINE", "INV-T1",
  "1",      "BASELINE", "INV-T2",
  "1",      "BASELINE", "INV-T3",
  "1",      "BASELINE", "INV-T4",
  "1",      "WEEK 1",   "INV-T1",
  "1",      "WEEK 1",   "INV-T2",
  "1",      "WEEK 1",   "INV-T4",
  "2",      "BASELINE", "INV-T1",
  "2",      "BASELINE", "INV-T2",
  "2",      "BASELINE", "INV-T3",
  "2",      "WEEK 1",   "INV-T1",
  "2",      "WEEK 1",   "INV-N1"
)

derive_var_merged_summary(
  adsl,
  dataset_add = adtr,
  by_vars = vars(USUBJID),
  filter_add = AVISIT == "BASELINE",
  new_var = LESIONSBL,
  analysis_var = LESIONID,
  summary_fun = function(x) paste(x, collapse = ", ")
)

}
\seealso{
\code{\link[=derive_summary_records]{derive_summary_records()}}, \code{\link[=get_summary_records]{get_summary_records()}}

General Derivation Functions for all ADaMs that returns variable appended to dataset:
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_extreme_flag}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_var_merged_exist_flag}()},
\code{\link{derive_var_obs_number}()},
\code{\link{derive_var_relative_flag}()},
\code{\link{derive_var_worst_flag}()},
\code{\link{derive_vars_joined}()},
\code{\link{derive_vars_last_dose}()},
\code{\link{derive_vars_merged_lookup}()},
\code{\link{derive_vars_merged}()},
\code{\link{derive_vars_transposed}()},
\code{\link{get_summary_records}()}
}
\author{
Stefan Bundfuss
}
\concept{der_gen}
\keyword{der_gen}
