% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period_dataset.R
\name{create_period_dataset}
\alias{create_period_dataset}
\title{Create a Reference Dataset for Subperiods, Periods, or Phases}
\usage{
create_period_dataset(
  dataset,
  new_vars,
  subject_keys = get_admiral_option("subject_keys")
)
}
\arguments{
\item{dataset}{ADSL dataset

The variables specified by \code{new_vars} and \code{subject_keys} are expected. For
each element of \code{new_vars} at least one variable of the form of the right
hand side value must be available in the dataset.}

\item{new_vars}{New variables

A named list of variables like \code{vars(PHSDT = PHwSDT, PHEDT = PHwEDT, APHASE = APHASEw)} is expected. The left hand side of the elements defines a
variable of the output dataset, the right hand side defines the source
variables from the ADSL dataset in CDISC notation.

If the lower case letter "w"  is used it refers to a phase variable, if the
lower case letters "xx" are used it refers to a period variable, and if
both "xx" and "w" are used it refers to a subperiod variable.

Only one type must be used, e.g., all right hand side values must refer to
period variables. It is not allowed to mix for example period and subperiod
variables. If period \emph{and} subperiod variables are required, separate
reference datasets must be created.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of quosures where the expressions are symbols as returned by
\code{vars()} is expected.}
}
\value{
A period reference dataset (see "Details" section)
}
\description{
The function creates a reference dataset for subperiods, periods, or phases
from the \code{ADSL} dataset. The reference dataset can be used to derive
subperiod, period, or phase variables like \code{ASPER}, \code{ASPRSDT}, \code{ASPREDT},
\code{APERIOD}, \code{APERSDT}, \code{APEREDT}, \code{TRTA}, \code{APHASEN}, \code{PHSDTM}, \code{PHEDTM}, ...
in OCCDS and BDS datasets.
}
\details{
For each subject and each subperiod/period/phase where at least one
of the source variable is not \code{NA} an observation is added to the output
dataset.

Depending on the type of the source variable (subperiod, period, or phase)
the variable \code{ASPER}, \code{APERIOD}, or \code{APHASEN} is added and set to the
number of the subperiod, period, or phase.

The variables specified for \code{new_vars} (left hand side) are added to the
output dataset and set to the value of the source variable (right hand
side).
}
\examples{
library(tibble)
library(dplyr, warn.conflicts = FALSE)
library(lubridate)

# Create reference dataset for periods
adsl <- tribble(
  ~USUBJID, ~AP01SDT,     ~AP01EDT,     ~AP02SDT,     ~AP02EDT,     ~TRT01A, ~TRT02A,
  "1",      "2021-01-04", "2021-02-06", "2021-02-07", "2021-03-07", "A",     "B",
  "2",      "2021-02-02", "2021-03-02", "2021-03-03", "2021-04-01", "B",     "A",
) \%>\%
  mutate(
    across(matches("AP\\\\d\\\\d[ES]DT"), ymd)
  ) \%>\%
  mutate(
    STUDYID = "xyz"
  )

create_period_dataset(
  adsl,
  new_vars = vars(APERSDT = APxxSDT, APEREDT = APxxEDT, TRTA = TRTxxA)
)

# Create reference dataset for phases
adsl <- tribble(
  ~USUBJID, ~PH1SDT,      ~PH1EDT,      ~PH2SDT,      ~PH2EDT,      ~APHASE1,    ~APHASE2,
  "1",      "2021-01-04", "2021-02-06", "2021-02-07", "2021-03-07", "TREATMENT", "FUP",
  "2",      "2021-02-02", "2021-03-02", NA,           NA,           "TREATMENT", NA
) \%>\%
  mutate(
    across(matches("PH\\\\d[ES]DT"), ymd)
  ) \%>\%
  mutate(
    STUDYID = "xyz"
  )

create_period_dataset(
  adsl,
  new_vars = vars(PHSDT = PHwSDT, PHEDT = PHwEDT, APHASE = APHASEw)
)

# Create reference datasets for subperiods
adsl <- tribble(
  ~USUBJID, ~P01S1SDT,    ~P01S1EDT,    ~P01S2SDT,    ~P01S2EDT,    ~P02S1SDT,    ~P02S1EDT,
  "1",      "2021-01-04", "2021-01-19", "2021-01-20", "2021-02-06", "2021-02-07", "2021-03-07",
  "2",      "2021-02-02", "2021-03-02", NA,           NA,           "2021-03-03", "2021-04-01"
) \%>\%
  mutate(
    across(matches("P\\\\d\\\\dS\\\\d[ES]DT"), ymd)
  ) \%>\%
  mutate(
    STUDYID = "xyz"
  )

create_period_dataset(
  adsl,
  new_vars = vars(ASPRSDT = PxxSwSDT, ASPREDT = PxxSwEDT)
)
}
\seealso{
\code{\link[=derive_vars_period]{derive_vars_period()}}

Creating auxiliary datasets: 
\code{\link{create_query_data}()},
\code{\link{create_single_dose_dataset}()}
}
\author{
Stefan Bundfuss
}
\concept{create_aux}
\keyword{create_aux}
