% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_tte.R
\name{censor_source}
\alias{censor_source}
\title{Create a \code{censor_source} Object}
\usage{
censor_source(
  dataset_name,
  filter = NULL,
  date,
  censor = 1,
  set_values_to = NULL
)
}
\arguments{
\item{dataset_name}{The name of the source dataset

The name refers to the dataset provided by the \code{source_datasets} parameter
of \code{derive_param_tte()}.}

\item{filter}{An unquoted condition for selecting the observations from
\code{dataset} which are events or possible censoring time points.}

\item{date}{A variable providing the date of the event or censoring. A date,
or a datetime can be specified. An unquoted symbol is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.}

\item{censor}{Censoring value

CDISC strongly recommends using \code{0} for events and positive integers for
censoring.}

\item{set_values_to}{A named list returned by \code{vars()} defining the variables
to be set for the event or censoring, e.g. \code{vars(EVENTDESC = "DEATH", SRCDOM = "ADSL", SRCVAR = "DTHDT")}. The values must be a symbol, a
character string, a numeric value, or \code{NA}.}
}
\value{
An object of class \code{censor_source}, inheriting from class \code{tte_source}
}
\description{
\code{censor_source} objects are used to define censorings as input for the
\code{derive_param_tte()} function.
}
\examples{
# Last study date known alive censor
censor_source(
  dataset_name = "adsl",
  date = LSTALVDT,
  set_values_to = vars(
    EVNTDESC = "ALIVE",
    SRCDOM = "ADSL",
    SRCVAR = "LSTALVDT"
  )
)
}
\seealso{
\code{\link[=derive_param_tte]{derive_param_tte()}}, \code{\link[=event_source]{event_source()}}

Source Specifications: 
\code{\link{assert_db_requirements}()},
\code{\link{assert_terms}()},
\code{\link{assert_valid_queries}()},
\code{\link{date_source}()},
\code{\link{death_event}},
\code{\link{derive_var_dthcaus}()},
\code{\link{event_source}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.sdg_select}()},
\code{\link{format.smq_select}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{query}()},
\code{\link{sdg_select}()},
\code{\link{smq_select}()},
\code{\link{tte_source}()},
\code{\link{validate_query}()},
\code{\link{validate_sdg_select}()},
\code{\link{validate_smq_select}()}
}
\author{
Stefan Bundfuss
}
\concept{source_specifications}
\keyword{source_specifications}
