% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_date.R
\name{derive_var_extreme_dtm}
\alias{derive_var_extreme_dtm}
\title{Derive First or Last Datetime from Multiple Sources}
\usage{
derive_var_extreme_dtm(
  dataset,
  new_var,
  ...,
  source_datasets,
  mode,
  subject_keys = vars(STUDYID, USUBJID)
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by \code{subject_keys} are required.}

\item{new_var}{Name of variable to create}

\item{...}{Source(s) of dates. One or more \code{date_source()} objects are
expected.}

\item{source_datasets}{A named \code{list} containing datasets in which to search
for the first or last date}

\item{mode}{Selection mode (first or last)

If \code{"first"} is specified, the first date for each subject is selected. If
\code{"last"} is specified, the last date for each subject is selected.

Permitted Values:  \code{"first"}, \code{"last"}}

\item{subject_keys}{Variables to uniquely identify a subject

A list of quosures where the expressions are symbols as returned by
\code{vars()} is expected.}
}
\value{
The input dataset with the new variable added.
}
\description{
Add the first or last datetime from multiple sources to the dataset, e.g.,
the last known alive datetime (\code{LSTALVDTM}).
}
\details{
The following steps are performed to create the output dataset:
\enumerate{
\item For each source dataset the observations as specified by the \code{filter}
element are selected. Then for each patient the first or last observation
(with respect to \code{date} and \code{mode}) is selected.
\item The new variable is set to the variable specified by the \code{date} element.
If this is a date variable (rather than datetime), then the time is imputed
as \code{"00:00:00"}.
\item The variables specified by the \code{traceability_vars} element are added.
\item The selected observations of all source datasets are combined into a
single dataset.
\item For each patient the first or last observation (with respect to the new
variable and \code{mode}) from the single dataset is selected and the new
variable is merged to the input dataset.
}
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data("admiral_dm")
data("admiral_ae")
data("admiral_lb")
data("admiral_adsl")

# derive last known alive datetime (LSTALVDTM)
ae_start <- date_source(
  dataset_name = "ae",
  date = AESTDTM
)
ae_end <- date_source(
  dataset_name = "ae",
  date = AEENDTM
)

ae_ext <- admiral_ae \%>\%
  derive_vars_dtm(
    dtc = AESTDTC,
    new_vars_prefix = "AEST",
    highest_imputation = "M"
  ) \%>\%
  derive_vars_dtm(
    dtc = AEENDTC,
    new_vars_prefix = "AEEN",
    highest_imputation = "M"
  )

lb_date <- date_source(
  dataset_name = "lb",
  date = LBDTM,
  filter = !is.na(LBDTM)
)

lb_ext <- derive_vars_dtm(
  admiral_lb,
  dtc = LBDTC,
  new_vars_prefix = "LB"
)

adsl_date <- date_source(dataset_name = "adsl", date = TRTEDTM)

admiral_dm \%>\%
  derive_var_extreme_dtm(
    new_var = LSTALVDTM,
    ae_start, ae_end, lb_date, adsl_date,
    source_datasets = list(
      adsl = admiral_adsl,
      ae = ae_ext, lb = lb_ext
    ),
    mode = "last"
  ) \%>\%
  select(USUBJID, LSTALVDTM)

# derive last alive datetime and traceability variables
ae_start <- date_source(
  dataset_name = "ae",
  date = AESTDTM,
  traceability_vars = vars(
    LALVDOM = "AE",
    LALVSEQ = AESEQ,
    LALVVAR = "AESTDTC"
  )
)

ae_end <- date_source(
  dataset_name = "ae",
  date = AEENDTM,
  traceability_vars = vars(
    LALVDOM = "AE",
    LALVSEQ = AESEQ,
    LALVVAR = "AEENDTC"
  )
)
lb_date <- date_source(
  dataset_name = "lb",
  date = LBDTM,
  filter = !is.na(LBDTM),
  traceability_vars = vars(
    LALVDOM = "LB",
    LALVSEQ = LBSEQ,
    LALVVAR = "LBDTC"
  )
)

adsl_date <- date_source(
  dataset_name = "adsl",
  date = TRTEDTM,
  traceability_vars = vars(
    LALVDOM = "ADSL",
    LALVSEQ = NA_integer_,
    LALVVAR = "TRTEDTM"
  )
)

admiral_dm \%>\%
  derive_var_extreme_dtm(
    new_var = LSTALVDTM,
    ae_start, ae_end, lb_date, adsl_date,
    source_datasets = list(
      adsl = admiral_adsl,
      ae = ae_ext,
      lb = lb_ext
    ),
    mode = "last"
  ) \%>\%
  select(USUBJID, LSTALVDTM, LALVDOM, LALVSEQ, LALVVAR)
}
\seealso{
\code{\link[=date_source]{date_source()}}, \code{\link[=derive_var_extreme_dt]{derive_var_extreme_dt()}},
\code{\link[=derive_vars_merged]{derive_vars_merged()}}

ADSL Functions that returns variable appended to dataset: 
\code{\link{derive_var_age_years}()},
\code{\link{derive_var_disposition_status}()},
\code{\link{derive_var_dthcaus}()},
\code{\link{derive_var_extreme_dt}()},
\code{\link{derive_vars_aage}()},
\code{\link{derive_vars_disposition_reason}()}
}
\author{
Stefan Bundfuss, Thomas Neitmann
}
\concept{der_adsl}
\keyword{der_adsl}
