% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_tte.R
\name{extend_source_datasets}
\alias{extend_source_datasets}
\title{Add By Groups to All Datasets if Necessary}
\usage{
extend_source_datasets(source_datasets, by_vars)
}
\arguments{
\item{source_datasets}{Source datasets

A named list of datasets is expected. Each dataset must contain either all
by variables or none of the by variables.}

\item{by_vars}{By variables}
}
\value{
The list of extended source datasets
}
\description{
The function ensures that the by variables are contained in all source
datasets.
}
\details{
\enumerate{
\item The by groups are determined as the union of the by groups occurring in
the source datasets.
\item For all source datasets which do not contain the by variables the source
dataset is replaced by the cartesian product of the source dataset and the
by groups.
}
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(lubridate)

adsl <- tibble::tribble(
  ~USUBJID, ~TRTSDT,           ~EOSDT,
  "01",     ymd("2020-12-06"), ymd("2021-03-06"),
  "02",     ymd("2021-01-16"), ymd("2021-02-03")
) \%>\%
  mutate(STUDYID = "AB42")

ae <- tibble::tribble(
  ~USUBJID, ~AESTDTC,           ~AESEQ, ~AEDECOD,
  "01",     "2021-01-03T10:56", 1,      "Flu",
  "01",     "2021-03-04",       2,      "Cough",
  "01",     "2021",             3,      "Flu"
) \%>\%
  mutate(STUDYID = "AB42")

extend_source_datasets(
  source_datasets = list(adsl = adsl, ae = ae),
  by_vars = vars(AEDECOD)
)
}
\author{
Stefan Bundfuss
}
\keyword{dev_utility}
