% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_last_dose_amt.R
\name{derive_var_last_dose_amt}
\alias{derive_var_last_dose_amt}
\title{Derive Last Dose Amount}
\usage{
derive_var_last_dose_amt(
  dataset,
  dataset_ex,
  filter_ex = NULL,
  by_vars = vars(STUDYID, USUBJID),
  dose_id = vars(),
  dose_date,
  analysis_date,
  single_dose_condition = (EXDOSFRQ == "ONCE"),
  new_var,
  dose_var = EXDOSE,
  traceability_vars = NULL
)
}
\arguments{
\item{dataset}{Input dataset.
The variables specified by the \code{by_vars} and \code{analysis_date} parameters are expected.}

\item{dataset_ex}{Input EX dataset.
The variables specified by the \code{by_vars}, \code{dose_date}, \code{new_vars} parameters,
and source variables from \code{traceability_vars} parameter are expected.}

\item{filter_ex}{Filtering condition applied to EX dataset.
For example, it can be used to filter for valid dose.
Defaults to NULL.}

\item{by_vars}{Variables to join by (created by \code{dplyr::vars}).}

\item{dose_id}{Variables to identify unique dose (created by \code{dplyr::vars}).
Defaults to empty \code{vars()}.}

\item{dose_date}{The EX dose date variable.}

\item{analysis_date}{The analysis date variable.}

\item{single_dose_condition}{The condition for checking if \code{dataset_ex} is single dose. An error
is issued if the condition is not true. Defaults to \code{(EXDOSFRQ == "ONCE")}.}

\item{new_var}{The new variable added to \code{dataset}.}

\item{dose_var}{The EX source dose amount variable. Defaults to \code{EXDOSE}.}

\item{traceability_vars}{A named list returned by \code{\link[=vars]{vars()}} listing the traceability variables,
e.g. \code{vars(LDOSEDOM = "EX", LDOSESEQ = EXSEQ)}.
The left-hand side (names of the list elements) gives the names of the traceability variables
in the returned dataset.
The right-hand side (values of the list elements) gives the values of the traceability variables
in the returned dataset.
These can be either strings or symbols referring to existing variables.}
}
\value{
Input dataset with additional column \code{new_var}.
}
\description{
Add a variable for dose amount from the last dose to the input dataset.
}
\details{
The last dose amount is derived as the dose amount where the maximum \code{dose_date} is
lower to or equal to the \code{analysis_date} per \code{by_vars} for each observation in \code{dataset}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data(ae)
data(ex_single)

ae \%>\%
  head(100) \%>\%
  derive_var_last_dose_amt(
    head(ex_single, 100),
    filter_ex = (EXDOSE > 0 | (EXDOSE == 0 & grepl("PLACEBO", EXTRT))) &
      nchar(EXENDTC) >= 10,
    dose_date = EXENDTC,
    analysis_date = AESTDTC,
    single_dose_condition = (EXSTDTC == EXENDTC),
    new_var = LDOSE,
    dose_var = EXDOSE
  ) \%>\%
  select(STUDYID, USUBJID, AESEQ, AESTDTC, LDOSE)

# or with traceability variables
ae \%>\%
  head(100) \%>\%
  derive_var_last_dose_amt(
    head(ex_single, 100),
    filter_ex = (EXDOSE > 0 | (EXDOSE == 0 & grepl("PLACEBO", EXTRT))) &
      nchar(EXENDTC) >= 10,
    dose_date = EXENDTC,
    analysis_date = AESTDTC,
    single_dose_condition = (EXSTDTC == EXENDTC),
    new_var = LDOSE,
    dose_var = EXDOSE,
    traceability_vars = dplyr::vars(LDOSEDOM = "EX", LDOSESEQ = EXSEQ, LDOSEVAR = "EXDOSE")
  ) \%>\%
  select(STUDYID, USUBJID, AESEQ, AESTDTC, LDOSEDOM, LDOSESEQ, LDOSEVAR, LDOSE)
}
\seealso{
\code{\link[=derive_vars_last_dose]{derive_vars_last_dose()}}
}
\author{
Annie Yang
}
\keyword{adam}
\keyword{derivation}
