% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_vignette.R
\name{dataset_vignette}
\alias{dataset_vignette}
\title{Output a Dataset in a Vignette in the admiral Format}
\usage{
dataset_vignette(dataset, display_vars = NULL, filter = NULL)
}
\arguments{
\item{dataset}{Dataset to output in the vignette}

\item{display_vars}{Variables selected to demonstrate the outcome of the derivation

Permitted Values: list of variables

Default is NULL

If \code{display_vars} is not NULL, only the selected variables are visible in the vignette while the
other variables are hidden. They can be made visible by clicking the\verb{Choose the columns to display} button.}

\item{filter}{Filter condition

The specified condition is applied to the dataset before it is displayed.

Permitted Values: a condition}
}
\value{
A HTML table
}
\description{
Output a dataset in a vignette with the pre-specified admiral format.
}
\examples{
library(admiral)
library(DT)
library(dplyr)
library(admiral.test)
data("dm")

dataset_vignette(dm)
dataset_vignette(dm, display_vars = vars(USUBJID, RFSTDTC, DTHDTC), filter = ARMCD == "Pbo")
}
\keyword{dev_utility}
