% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_symbol}
\alias{assert_symbol}
\title{Is an Argument a Symbol?}
\usage{
assert_symbol(arg, optional = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked. Must be a \code{quosure}. See examples.}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not a symbol and returns the input
invisibly otherwise.
}
\description{
Checks if an argument is a symbol
}
\examples{
library(admiral.test)
data(dm)

example_fun <- function(dat, var) {
  var <- assert_symbol(rlang::enquo(var))
  dplyr::select(dat, !!var)
}

example_fun(dm, USUBJID)

try(example_fun(dm))

try(example_fun(dm, "USUBJID"))

try(example_fun(dm, toupper(PARAMCD)))
}
\author{
Thomas Neitmann
}
\keyword{assertion}
