% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_date_vars.R
\name{get_imputation_target_time}
\alias{get_imputation_target_time}
\title{Get Time Imputation Targets}
\usage{
get_imputation_target_time(time_imputation)
}
\arguments{
\item{time_imputation}{The value to impute the time when a timepart is
missing.

A character value is expected, either as a
\itemize{
\item format with hour, min and sec specified as \code{"hh:mm:ss"}: e.g. \code{"00:00:00"}
for the start of the day,
\item or as a keyword: \code{"first"},\code{"last"} to impute to the start/end of a day.
}}
}
\value{
A list of character vectors. The elements of the list are named
"hour", "minute", "second".
}
\description{
Get Time Imputation Targets
}
\details{
\itemize{
\item For \code{time_imputation = "first"} \code{"00"}, \code{"00"}, \code{"00"} are returned.
\item For \code{time_imputation = "last"} \code{"23"}, \code{"59"}, \code{"59"} are returned.
\item For \code{time_imputation = "<hh>:<mm>:<ss>"} \code{"<hh>"}, \code{"<mm>"}, \code{"<ss>"} are returned.
}
}
\seealso{
\code{\link[=impute_dtc_dtm]{impute_dtc_dtm()}}

Utilities used for date imputation: 
\code{\link{dt_level}()},
\code{\link{dtm_level}()},
\code{\link{get_imputation_target_date}()},
\code{\link{get_partialdatetime}()},
\code{\link{restrict_imputed_dtc_dtm}()},
\code{\link{restrict_imputed_dtc_dt}()}
}
\concept{utils_impute}
\keyword{utils_impute}
