% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_anrind.R
\name{derive_var_anrind}
\alias{derive_var_anrind}
\title{Derive Reference Range Indicator}
\usage{
derive_var_anrind(dataset)
}
\arguments{
\item{dataset}{The input dataset}
}
\value{
The input dataset with additional column \code{ANRIND}
}
\description{
Derive Reference Range Indicator
}
\details{
\code{ANRIND} is set to
\itemize{
\item \code{"NORMAL"} if \code{AVAL} is greater or equal \code{ANRLO} and less than
or equal \code{ANRHI}; or if \code{AVAL} is greater than or equal \code{ANRLO} and \code{ANRHI}
is missing; or if \code{AVAL} is less than or equal \code{ANRHI} and \code{ANRLO} is
missing
\item \code{"LOW"} if \code{AVAL} is less than \code{ANRLO} and either \code{A1LO} is missing or \code{AVAL}
is greater than or equal \code{A1LO}
\item \code{"HIGH"} if \code{AVAL} is greater than \code{ANRHI} and either \code{A1HI} is missing or \code{AVAL}
is less than or equal \code{A1HI}
\item \code{"LOW LOW"} if \code{AVAL} is less than \code{A1LO}
\item \code{"HIGH HIGH"} if \code{AVAL} is greater than \code{A1HI}
}
}
\examples{
library(tibble)
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data(admiral_vs)

ref_ranges <- tribble(
  ~PARAMCD, ~ANRLO, ~ANRHI, ~A1LO, ~A1HI,
  "DIABP",      60,     80,    40,    90,
  "PULSE",      60,    100,    40,   110
)

admiral_vs \%>\%
  mutate(
    PARAMCD = VSTESTCD,
    AVAL = VSSTRESN
  ) \%>\%
  filter(PARAMCD \%in\% c("PULSE", "DIABP")) \%>\%
  derive_vars_merged(ref_ranges, by_vars = exprs(PARAMCD)) \%>\%
  derive_var_anrind() \%>\%
  select(USUBJID, PARAMCD, AVAL, ANRLO:ANRIND)
}
\seealso{
BDS-Findings Functions that returns variable appended to dataset: 
\code{\link{derive_var_analysis_ratio}()},
\code{\link{derive_var_atoxgr_dir}()},
\code{\link{derive_var_atoxgr}()},
\code{\link{derive_var_basetype}()},
\code{\link{derive_var_base}()},
\code{\link{derive_var_chg}()},
\code{\link{derive_var_ontrtfl}()},
\code{\link{derive_var_pchg}()},
\code{\link{derive_var_shift}()}
}
\concept{der_bds_findings}
\keyword{der_bds_findings}
