% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msr.mantelrtest.R
\name{msr.mantelrtest}
\alias{msr.mantelrtest}
\title{Moran spectral randomization for Mantel test}
\usage{
\method{msr}{mantelrtest}(x, listwORorthobasis, nrepet = x$rep,
  method = c("pair", "triplet", "singleton"), ...)
}
\arguments{
\item{x}{An object generated by the \code{mantel.randtest} function.}

\item{listwORorthobasis}{an object of the class \code{listw} (spatial
weights) created by the functions of the \pkg{spdep} package or an object
of class \code{orthobasis}}

\item{nrepet}{an \code{integer} indicating the number of replicates}

\item{method}{an character specifying which algorithm should be used to
produce spatial replicates (see \code{\link{msr.default}}).}

\item{\dots}{further arguments of the \code{\link{msr.default}} function.}
}
\value{
An object of class \code{randtest}.
}
\description{
This function allows to test the Mantel statistic using constrained null
models in the presence of spatial autocorrelation. Random replicates of the
second distance matrix are produced. They are spatially-constrained to
preserve the global autocorrelation (Moran's I) and the spatial structures at
multiple scales. Multiscale property is defined by the power spectrum (i.e.
decomposition of the variance of the original variables) on a basis of
orthonormal eigenvectors (Moran's Eigenvector Maps, MEM).
}
\examples{

if(require("ade4", quietly = TRUE)
& require("spdep", quietly = TRUE)){
data(mafragh, package = "ade4")

d1 <- dist(mafragh$env[,1:3])
d2 <- dist(mafragh$env[,7])
t1 <- mantel.randtest(d1,d2)
t1

lw <- nb2listw(mafragh$nb)
t2 <- msr(t1, listwORorthobasis = lw)
t2

}

}
\references{
Crabot, J., Clappe, S., Dray, S. and Datry, T. (2019) Testing the
  Mantel statistic with a spatially-constrained permutation procedure.
  Methods in Ecology and Evolution. in press.
}
\seealso{
\code{\link{msr.default}}, \code{\link[ade4]{mantel.randtest}}
}
\author{
Sylvie Clappe, Stephane Dray \email{stephane.dray@univ-lyon1.fr}
}
\keyword{spatial}
