% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthobasis.poly.R
\name{orthobasis.poly}
\alias{orthobasis.poly}
\title{Function to compute polynomial of geographical coordinates}
\usage{
orthobasis.poly(coords, degree = 2, wt = rep(1/nrow(coords), nrow(coords)))
}
\arguments{
\item{coords}{either a \code{Spatial*} object or a \code{matrix} with 
geographic coordinates}

\item{degree}{the degree of the polynomial}

\item{wt}{a vector of weights. It is used to orthogonalize the polynomial 
functions}
}
\value{
an object of class \code{orthobasisSp} , subclass \code{orthobasis}
}
\description{
This function computes orthgonal polynomials of geographical coordinates. Polynomials 
functions are orthogonal and centred for the weights defined in \code{wt} 
(i.e., orthogonal to \code{wt}). It is the classical approach to perform 
trend surface analysis.
}
\examples{

if(require("ade4", quietly = TRUE)){
data(mafragh, package = "ade4")
pol2 <- orthobasis.poly(mafragh$Spatial) 

if(require("adegraphics", quietly = TRUE)){
plot(pol2, mafragh$Spatial)
}
}


}
\author{
Stéphane Dray \email{stephane.dray@univ-lyon1.fr}
}
\references{
Dray S., Pélissier R., Couteron P., Fortin M.J., Legendre P., Peres-Neto
P.R., Bellier E., Bivand R., Blanchet F.G., De Caceres M., Dufour A.B.,
Heegaard E., Jombart T., Munoz F., Oksanen J., Thioulouse J., Wagner H.H.
(2012). Community ecology in the age of multivariate multiscale spatial
analysis. \emph{Ecological Monographs} \bold{82}, 257--275.
}
\seealso{
\code{\link{mem}} \code{\link[ade4]{orthobasis}}
}
\keyword{spatial}

