"hr.rast" <- function(mcp, w)
{
    if (!inherits(w, "SpatialPixels"))
        stop("w should inherits the class SpatialPixels\n (see ?SpatialPixels-class)")
    pfs1 <- proj4string(mcp)
    pfs2 <- proj4string(w)
    if (!identical(pfs1,pfs2))
        stop("non identical projection for mcp and w")

    gridded(w) <- TRUE
    gr <- gridparameters(w)
    if (nrow(gr) > 2)
        stop("w should be defined in two dimensions")

    if (!inherits(mcp, "SpatialPolygonsDataFrame"))
        stop("mcp should have been generated by the function mcp")
    res <- do.call("data.frame", lapply(1:nrow(as.data.frame(mcp)),
                                        function(i) {
                                            overlay(w, mcp[i,])
                                        }))
    names(res) <- as.data.frame(mcp)$id
    coordinates(res) <- coordinates(w)
    gridded(res) <- TRUE
    if (!is.na(pfs1))
        proj4string(res) <- pfs1
    return(res)
}

