% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_to_mvmapper.R
\name{export_to_mvmapper}
\alias{export_to_mvmapper}
\alias{export_to_mvmapper.default}
\alias{export_to_mvmapper.dapc}
\alias{export_to_mvmapper.dudi}
\alias{export_to_mvmapper.spca}
\title{Export analysis for mvmapper visualisation}
\usage{
export_to_mvmapper(x, ...)

\method{export_to_mvmapper}{default}(x, ...)

\method{export_to_mvmapper}{dapc}(x, info, write_file = TRUE,
  out_file = NULL, ...)

\method{export_to_mvmapper}{dudi}(x, info, write_file = TRUE,
  out_file = NULL, ...)

\method{export_to_mvmapper}{spca}(x, info, write_file = TRUE,
  out_file = NULL, ...)
}
\arguments{
\item{x}{The analysis to be exported. Can be a \code{dapc}, \code{spca}, or a
\code{dudi} object.}

\item{...}{Further arguments to pass to other methods.}

\item{info}{A \code{data.frame} with additional information containing at
least the following columns: \code{key} (unique individual identifier),
\code{lat} (latitude), and \code{lon} (longitude). Other columns will be
exported as well, but are optional.}

\item{write_file}{A \code{logical} indicating if the output should be written
out to a .csv file. Defaults to \code{TRUE}.}

\item{out_file}{A character string indicating the file to which the output
should be written. If NULL, the file used will be named
\code{'mvmapper_data_[date and time].csv'}}
}
\value{
A \code{data.frame} which can serve as input to \code{mvmapper},
containing at least the following columns:

\itemize{

\item \code{key}: unique individual identifiers

\item \code{PC1}: first principal component; further principal components are
optional, but if provided will be numbered and follow \code{PC1}.

\item \code{lat}: latitude for each individual

\item \code{lon}: longitude for each individual

}

In addition, specific information is added for some analyses:

\itemize{

\item \code{spca}: \code{Lag_PC} columns contain the lag-vectors of the
principal components; the lag operator computes, for each individual, the
average score of neighbouring individuals; it is useful for clarifying
patches and clines.

\item \code{dapc}: \code{grp} is the group used in the analysis;
\code{assigned_grp} is the group assignment based on the discriminant
functions; \code{support} is the statistical support (i.e. assignment
probability) for \code{assigned_grp}.

}
}
\description{
\code{mvmapper} is an interactive tool for visualising outputs of a
multivariate analysis on a map from a web browser. The function
\code{export_to_mvmapper} is a generic with methods for several standard
classes of analyses in \code{adegenet} and \code{ade4}. Information on
individual locations, as well as any other relevant data, is passed through
the second argument \code{info}. By default, the function returns a formatted
\code{data.frame} and writes the output to a .csv file.\cr
}
\details{
\code{mvmapper} can be found at:
\url{https://popphylotools.github.io/mvMapper/}
}
\examples{

data(sim2pop)

dapc1 <- dapc(sim2pop, n.pca = 10, n.da = 1)

info <- data.frame(key = indNames(sim2pop),
                   lat = other(sim2pop)$xy[,2],
                   lon = other(sim2pop)$xy[,1],
                   Population = pop(sim2pop))

out <- export_to_mvmapper(dapc1, info, write_file = FALSE)
head(out)

data(rupica)

spca1 <- spca(rupica, type=5, d1 = 0, d2 = 2300,
              plot = FALSE, scannf = FALSE,
              nfposi = 2,nfnega = 0)

info <- data.frame(key = indNames(rupica),
                   lat = rupica$other$xy[,2],
                   lon = rupica$other$xy[,1])

out <- export_to_mvmapper(spca1, info, write_file = FALSE)
head(out)

}
\seealso{
\code{mvmapper} is available at:
\url{https://popphylotools.github.io/mvMapper/}
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
