% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/import.R
\name{read.genetix}
\alias{read.genetix}
\title{Reading data from GENETIX}
\usage{
read.genetix(file = NULL, quiet = FALSE)
}
\arguments{
\item{file}{a character string giving the path to the file to convert, with
the appropriate extension.}

\item{quiet}{logical stating whether a conversion message must be printed
(TRUE,default) or not (FALSE).}
}
\value{
an object of the class \code{genind}
}
\description{
The function \code{read.genetix} reads GENETIX data files (.gtx) and convert
them into a \linkS4class{genind} object.
}
\details{
Note: \code{read.genetix} is meant for DIPLOID DATA ONLY. Haploid data with
the GENETIX format can be read into R using \code{read.table} or
\code{read.csv} after removing headers and 'POP' lines, and then converted
using \code{\link{df2genind}}.
}
\examples{
obj <- read.genetix(system.file("files/nancycats.gtx",package="adegenet"))
obj
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\references{
Belkhir K., Borsa P., Chikhi L., Raufaste N. & Bonhomme F.
(1996-2004) GENETIX 4.05, logiciel sous Windows TM pour la genetique des
populations. Laboratoire Genome, Populations, Interactions, CNRS UMR 5000,
Universite de Montpellier II, Montpellier (France). \cr
}
\seealso{
\code{\link{import2genind}}, \code{\link{df2genind}},
\code{\link{read.fstat}}, \code{\link{read.structure}},
\code{\link{read.genepop}}
}
\keyword{manip}

