% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff_dea.R
\name{eff_dea}
\alias{eff_dea}
\title{Compute efficiencies for (standard) DEA model}
\usage{
eff_dea(input, output, orientation, ux, vy)
}
\arguments{
\item{input}{A matrix or a data frame containing the inputs of the units to be evaluated, with one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame containing the outputs of the units to be evaluated, with one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or "output" for output orientation in DEA model.
The default is "input".}
}
\value{
eff
}
\description{
For the given orientation, input, output and weights compute DMU's efficiencies
}
\details{
Unlike the dea function, this function expects input and output to be arrays or data.frames, not vectors.

Note: As this function is mainly for internal use, to avoid unnecessary overload, it does not do an extensive check of the input parameters. Use the higher level dea function instead.
}
\keyword{internal}
