% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adea_load_leverage.R
\name{adea_load_leverage}
\alias{adea_load_leverage}
\title{Search for leverage units (DMU's) with a greater impact on load levels in DEA analysis}
\usage{
adea_load_leverage(
  input,
  output,
  orientation = c("input", "output"),
  load.orientation = c("inoutput", "input", "output"),
  load.diff = 0.05,
  ndel = 1,
  nmax = 0,
  solver = "auto"
)
}
\arguments{
\item{input}{A matrix or a data frame containing the inputs of the units to be evaluated, with one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame containing the outputs of the units to be evaluated, with one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or "output" for output orientation in DEA model.
The default is "input".}

\item{load.orientation}{This parameter allows the selection of variables to be included in load analysis. 
The default is "inoutput" which means that all input and output variables will be included. Use "input" or "output" to include only input or output variables in load analysis.}

\item{load.diff}{Minimum difference in load to consider a subset of DMUs as a leverage one}

\item{ndel}{Maximum number of units to drop out in each try.}

\item{nmax}{Maximum number of DMU sets to include in results. 0 for no limit.}

\item{solver}{The solver used by ROI to solve the DEA optimization problem.
The default is "auto."
The solver must be installed and capable of solving linear programming problems. 
Use \code{ROI_installed_solvers()} to list them.}
}
\value{
The function returns a list with the following named members:
\itemize{
\item loads: Load of each model after removing the corresponding DMUs
\item loads.diff: For each model the difference between its load and the original one
\item dmu.indexs: Index of DMUs removed in each model
}
}
\description{
Search for leverage units (DMU's) with a greater impact on load levels in DEA analysis.
}
\details{
A leverage unit is a DMU that significantly alters the results of the current procedure, in this case, a DMU that produce a large change in variable loads.
}
\note{
This function has to solve a large number of large linear programs that grows with DMUs. So computation time required may be very large, be patient.
}
\examples{
data('cardealers4')
input <- cardealers4[, c('Employees', 'Depreciation')]
output <- cardealers4[, c('CarsSold', 'WorkOrders')]
adea_load_leverage(input, output, ndel = 2)
#         load  load.diff DMUs
# 1  1.0000000 0.33333333 1, 6
# 2  1.0000000 0.33333333 3, 4
# 3  1.0000000 0.33333333 2, 3
# 4  1.0000000 0.33333333 2, 5
# 5  1.0000000 0.33333333 4, 6
# 6  1.0000000 0.33333333    2
# 7  1.0000000 0.33333333 1, 4
# 8  1.0000000 0.33333333 2, 6
# 9  1.0000000 0.33333333 1, 2
# 10 0.9635628 0.29689609 2, 4
# 11 0.8743243 0.20765766 5, 6
# 12 0.8479940 0.18132736 1, 3
# 13 0.8420551 0.17538843 3, 6
# 14 0.8243243 0.15765766 1, 5
# 15 0.8000000 0.13333333    6
# 16 0.8000000 0.13333333    4
# 17 0.8000000 0.13333333    1
# 18 0.8000000 0.13333333    3
# 19 0.7461771 0.07951041 3, 5
# 20 0.7358231 0.06915643    5

}
