% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbSendQuery_AdbiConnection_character.R,
%   R/dbSendStatement_AdbiConnection_character.R
\name{dbSendQuery_AdbiConnection_character}
\alias{dbSendQuery_AdbiConnection_character}
\alias{dbSendQuery,AdbiConnection,character-method}
\alias{dbSendStatement_AdbiConnection_character}
\alias{dbSendStatement,AdbiConnection,character-method}
\title{Create result sets}
\usage{
\S4method{dbSendQuery}{AdbiConnection,character}(
  conn,
  statement,
  ...,
  params = NULL,
  immediate = NULL,
  bigint = NULL
)

\S4method{dbSendStatement}{AdbiConnection,character}(
  conn,
  statement,
  ...,
  params = NULL,
  immediate = NULL,
  bigint = NULL
)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}

\item{params}{Optional query parameters (forwarded to \code{\link[=dbBind]{dbBind()}})}

\item{immediate}{Passing a value \code{TRUE} is intended for statements containing
no placeholders and \code{FALSE} otherwise. The default value \code{NULL} will
inspect the statement for presence of placeholders (will \code{PREPARE} the
statement)}

\item{bigint}{The R type that 64-bit integer types should be mapped to,
default is chosen according to the connection setting}
}
\value{
An S4 class \code{AdbiResult} (inheriting from \linkS4class{DBIResult}).
}
\description{
Creating result sets using \code{\link[=dbSendQuery]{dbSendQuery()}} (and by extension using
\code{\link[=dbGetQuery]{dbGetQuery()}}) mostly follows DBI specification. One way where adbi
deviates from DBI mechanisms is how the \code{bigint} setting is not only per
connection, but the per-connection setting can be overridden on a result
set basis. As default, the connection setting is applied, but passing one
of the accepted values as \code{bigint} when creating a result set will
subsequently use that setting for all fetches using this result set.
}
\examples{
if (requireNamespace("adbcsqlite")) {
  library(DBI)
  con <- dbConnect(adbi::adbi("adbcsqlite"), uri = ":memory:")
  dbWriteTable(con, "swiss", swiss)
  str(
    dbGetQuery(con, "SELECT Examination from swiss WHERE Agriculture < 30")
  )
  str(
    dbGetQuery(con, "SELECT Examination from swiss WHERE Agriculture < 30",
      bigint = "integer")
  )
  dbDisconnect(con)
}
}
\seealso{
adbi-driver
}
