% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{daniel_plot_qq}
\alias{daniel_plot_qq}
\title{Daniel's plot (quantile-quantile)}
\usage{
daniel_plot_qq(model, alpha = 0.5, xlim = c(-3, 3))
}
\arguments{
\item{model}{a linear model}

\item{alpha}{the transparency of the horizontal lines}

\item{xlim}{the limits of the x-axis}
}
\value{
a QQ plot (GGPlot2 object) with the effects of the model
}
\description{
Given a non-replicated model of a factorial plan, this function provides a
QQ plot of the effects of the model, labeling all the effects.
}
\examples{
daniel_plot_qq(lm(Y~A*B*C*D, data=filtration))
}
