% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{summary.adaptProjBatch}
\alias{summary.adaptProjBatch}
\title{Summarize adaptProjBatch Objects}
\usage{
\method{summary}{adaptProjBatch}(
  object,
  finalN_mean = FALSE,
  finalN_used = 100,
  threshold = 1,
  inf_alive = TRUE,
  ext_time = FALSE,
  print_output = FALSE,
  ...
)
}
\arguments{
\item{object}{An \code{adaptProjBatch} object.}

\item{finalN_mean}{A logical value indicating whether to take the arithmetic
mean of the final population sizes for each MPM in each projection. Defaults
to \code{FALSE}, in which case only the final population sizes are reported.}

\item{finalN_used}{An integer value indicating the number of final population
sizes in the arithmetic mean noted in argument \code{finalN_mean}. Defaults
to \code{100}, unless the projections are for fewer time steps, in which case
defaults to \code{10}.}

\item{threshold}{A threshold population size to be searched for in
projections. Defaults to 1.}

\item{inf_alive}{A logical value indicating whether to treat infinitely
large population size as indicating that the population is still extant.
If \code{FALSE}, then the population is considered extinct. Defaults to
\code{TRUE}.}

\item{ext_time}{A logical value indicating whether to output extinction times
per population-patch. Defaults to \code{FALSE}.}

\item{print_output}{A logical value indicating whether to print the output
data frame to the screen. Defaults to \code{FALSE}.}

\item{...}{Other parameters currently not utilized.}
}
\value{
Apart from a statement of the results, this function outputs a data
frame with the following elements:
\item{projection}{The identity of the current projection in the original
\code{adaptProjBatch} object.}
\item{target_mpm}{The identity of the MPM targeted for alteration in the
batch projection.}
\item{stage3}{Stage at occasion \emph{t}+1 in the transition replaced.}
\item{stage2}{Stage at occasion \emph{t} in the transition replaced.}
\item{stage1}{Stage at occasion \emph{t}-1 in the transition replaced.}
\item{age2}{Age at occasion \emph{t} in the transition replaced.}
\item{eststage3}{Stage at occasion \emph{t}+1 in the transition to replace
the transition designated by \code{stage3}, \code{stage2}, and
\code{stage1}.}
\item{eststage2}{Stage at occasion \emph{t} in the transition to replace
the transition designated by \code{stage3}, \code{stage2}, and
\code{stage1}.}
\item{eststage1}{Stage at occasion \emph{t}-1 in the transition to replace
the transition designated by \code{stage3}, \code{stage2}, and
\code{stage1}.}
\item{estage2}{Age at occasion \emph{t} in the transition to replace
the transition designated by \code{age2}.}
\item{givenrate}{A constant to be used as the value of the transition.}
\item{offset}{A constant value to be added to the transition or proxy
transition.}
\item{multiplier}{A multiplier for proxy transitions or for fecundity.}
\item{convtype}{Designates whether the transition from occasion \emph{t} to
occasion \emph{t}+1 is a survival transition probability (1), a fecundity
rate (2), or a fecundity multiplier (3).}
\item{convtype_t12}{Designates whether the transition from occasion
\emph{t}-1 to occasion \emph{t} is a survival transition probability (1), or
a fecundity rate (2).}
\item{rep}{The identity of the replicate being summarized, within the
current projection.}
\item{mpm}{The identity of the MPM for which the population summary
corresponding to the row in question is being given.}
\item{final_N}{The final population size, meaning the population size given
for the current MPM in the current replicate in the current projection, in
the final time recorded.}
\item{extinct_by}{The first time by which the population size goes below the
extinction threshold, or hits 0.}
\item{final_N_mean}{The mean population size during the final
\code{finalN_used} times for the current MPM in the current replicate in the
current projection.}

\item{extinction_times}{A dataframe showing the numbers of replicates going
extinct (\code{ext_reps}) and mean extinction time (\code{ext_time}) per
population-patch. If \code{ext_time = FALSE}, then only outputs \code{NA}.}
}
\description{
Function \code{summary.adaptProjBatch()} summarizes \code{adaptProjBatch}
objects.
}
\section{Notes}{

The \code{inf_alive} and \code{ext_time} options both assess whether
replicates have reached a value of \code{NaN} or \code{Inf}. If
\code{inf_alive = TRUE} or \code{ext_time = TRUE} and one of these values is
found, then the replicate is counted in the \code{milepost_sums} object if
the last numeric value in the replicate is above the \code{threshold} value,
and is counted as extant and not extinct if the last numeric value in the
replicate is above the extinction threshold of a single individual.

Extinction time is calculated on the basis of whether the replicate ever
falls below a single individual. A replicate with a positive population size
below 0.0 that manages to rise above 1.0 individual is still considered to
have gone extinct the first time it crossed below 1.0.

If the input \code{lefkoProj} object is a mixture of two or more other
\code{lefkoProj} objects, then mileposts will be given relative to the
maximum number of time steps noted.
}

\examples{
library(lefko3)
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

sizevector <- c(0, 0, 3.0, 15)
stagevector <- c("P1", "D", "Sm", "Lg")
repvector <- c(0, 0, 1, 1)
obsvector <- c(0, 0, 1, 1)
matvector <- c(0, 1, 1, 1)
immvector <- c(1, 0, 0, 0)
indataset <- c(0, 1, 1, 1)
binvec <- c(0, 0.5, 2.5, 9.5)

cypframe_small_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypraw_v2 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_small_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypraw_v3 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  NAas0 = TRUE, NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 1500, 500),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)
cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")
cypmean <- lmean(cypmatrix2r)

cypsupp2r_small <- supplemental(stage3 = c("D", "Sm", "Lg", "P1"),
  stage2 = c("P1", "P1", "P1", "rep"), eststage3 = c(NA, "Sm", "Lg", NA),
  eststage2 = c(NA, "D", "D", NA), givenrate = c(0.05, NA, NA, NA),
  offset = c(NA, NA, -0.1, NA), multiplier = c(NA, NA, NA, 0.5),
  type =c(1, 1, 1, 3), stageframe = cypframe_small_raw, historical = FALSE)
cypmatrix2r_small <- rlefko2(data = cypraw_v2, stageframe = cypframe_small_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r_small,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")
cypmean_small <- lmean(cypmatrix2r_small)

cypmatrixL_small <- rleslie(data = cypraw_v3, start_age = 1, last_age = 4,
  continue = TRUE, fecage_min = 3, year = "all", pop = NA, patch = "all",
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

cyp_mpms1 <- list(cypmatrix2r, cypmatrix2r_small, cypmatrixL_small)

c2d_4 <- density_input(cypmean, stage3 = c("P1", "P1"), stage2= c("SD", "rep"),
  style = 1, time_delay = 1, alpha = 1, beta = 0.0005, type = c(2, 2))
c2d_4a <- density_input(cypmean_small, stage3 = c("P1", "P1"), stage2= c("P1", "rep"),
  style = 1, time_delay = 1, alpha = 1, beta = 0.0005, type = c(2, 2))
cypL_dv <- density_input(cypmatrixL_small, stage3 = c("Age1"), stage2 = c("rep"),
  style = c(1), alpha = c(0.5), beta = c(1.0), type = c(2))
cyp_density <- list(c2d_4, c2d_4a, cypL_dv)

cyp_start1 <- start_input(cypmatrix2r, stage2 = c("SD", "P1", "D"),
  value = c(100, 200, 4))
cyp_start2 <- start_input(cypmatrix2r_small, stage2 = c("P1", "D"),
  value = c(10, 2000))
cypL_start_1 <- start_input(cypmatrixL_small, stage2 = c("Age1"),
  value = c(200))
cyp_start <- list(cyp_start1, cyp_start2, cypL_start_1)

new_supplement_cyp2_small <- sup_skeleton(2)
new_supplement_cyp2_small$stage3 <- c("D", "Sm")
new_supplement_cyp2_small$stage2 <- c("Lg", "Lg")
new_supplement_cyp2_small$convtype <- c(1, 1)
used_supplements <- list(new_supplement_cyp2_small,
  new_supplement_cyp2_small, NULL)

aaa1_prj_batch2 <- batch_project3(used_mpms = "all", all_elems = FALSE,
  mpms =  cyp_mpms1, entry_time = c(0, 5, 8), times = 15, nreps = 3,
  supplement = used_supplements, integeronly = TRUE, density = cyp_density)
  
summary(aaa1_prj_batch2)

}
