% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ID_sync.R
\name{ID.sync}
\alias{ID.sync}
\title{Returns the source files needed to repair synchrony}
\usage{
ID.sync(file.info, dag.to.sync)
}
\arguments{
\item{file.info}{Project file information}

\item{dag.to.sync}{Directed Acyclic graph in need of synchronization}
}
\value{
data.frame with sources that need to be run, rows in run order
}
\description{
Returns the source files needed to repair synchrony
}
\examples{
\dontrun{
projInfo <- get.project.info(pull_source_info("adaprHome")$dependency.dir)
trees <- Harvest.trees(pull_source_info("adaprHome")$dependency.dir)
file.info <-Condense.file.info(trees)
ID.sync(file.info,projInfo$graph) 
} 
}

