% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobenius_norm_funct_multiv.R
\name{frobenius_norm_funct_multiv}
\alias{frobenius_norm_funct_multiv}
\title{Functional multivariate Frobenius norm}
\usage{
frobenius_norm_funct_multiv(m, PM)
}
\arguments{
\item{m}{Data matrix with the residuals. This matrix has 
the same dimensions as the original data matrix.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}
}
\value{
Real number.
}
\description{
Computes the functional multivariate Frobenius norm.
}
\details{
Residuals are vectors. If there are p variables (columns),
for every observation there is a residual that there is 
a p-dimensional vector. If there are n observations, the
residuals are an n times p matrix.
}
\examples{
mat <- matrix(1:400, ncol = 20)
PM <- matrix(1:100, ncol = 10)
frobenius_norm_funct_multiv(mat, PM)
                 
}
\author{
Guillermo Vinue
}
