% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposed_df_helpers.R
\name{is_exposed_df}
\alias{is_exposed_df}
\alias{as_exposed_df}
\title{Exposed data frame helper functions}
\usage{
is_exposed_df(x)

as_exposed_df(
  x,
  end_date,
  start_date = as.Date("1900-01-01"),
  target_status = NULL,
  cal_expo = FALSE,
  expo_length = c("year", "quarter", "month", "week"),
  trx_types = NULL,
  col_pol_num,
  col_status,
  col_exposure,
  col_pol_per,
  cols_dates,
  col_trx_n_ = "trx_n_",
  col_trx_amt_ = "trx_amt_"
)
}
\arguments{
\item{x}{an object. For \code{as_exposed_df()}, \code{x} must be a data frame.}

\item{end_date}{experience study end date}

\item{start_date}{experience study start date. Default value = 1900-01-01.}

\item{target_status}{character vector of target status values. Default value = \code{NULL}.}

\item{cal_expo}{set to TRUE for calendar year exposures. Otherwise policy year exposures are assumed.}

\item{expo_length}{exposure period length}

\item{trx_types}{Optional. Character vector containing unique transaction
types that have been attached to \code{x}. For each value in \code{trx_types},
\code{as_exposed_df} requires that columns exist in \code{x} named \verb{trx_n_\{*\}} and
\verb{trx_amt_\{*\}} containing transaction counts and amounts, respectively. The
prefixes "trx_n_" and "trx_amt_" can be overridden using the \code{col_trx_n_}
and \code{col_trx_amt_} arguments.}

\item{col_pol_num}{Optional. Name of the column in \code{x} containing the policy
number. The assumed default is "pol_num".}

\item{col_status}{Optional. Name of the column in \code{x} containing the policy
status. The assumed default is "status".}

\item{col_exposure}{Optional. Name of the column in \code{x} containing exposures.
The assumed default is "exposure".}

\item{col_pol_per}{Optional. Name of the column in \code{x} containing policy
exposure periods. Only necessary if \code{cal_expo} is \code{FALSE}. The assumed
default is either "pol_yr", "pol_qtr", "pol_mth", or "pol_wk" depending on
the value of \code{expo_length}.}

\item{cols_dates}{Optional. Names of the columns in \code{x} containing exposure
start and end dates. Both date ranges are assumed to be exclusive. The
assumed default is of the form \emph{A}_\emph{B}. \emph{A} is "cal" if \code{cal_expo} is \code{TRUE}
or "pol" otherwise. \emph{B} is either "yr", "qtr", "mth", or "wk" depending on
the value of \code{expo_length}.}

\item{col_trx_n_}{Optional. Prefix to use for columns containing transaction
counts.}

\item{col_trx_amt_}{Optional. Prefix to use for columns containing transaction
amounts.}
}
\value{
For \code{is_exposed_df()}, a length-1 logical vector. For
\code{as_exposed_df()}, an \code{exposed_df} object.
}
\description{
Test for and coerce to the \code{exposed_df} class.
}
\details{
\code{is_exposed_df()} will return \code{TRUE} if \code{x} is an \code{exposed_df} object.

\code{as_exposed_df()} will coerce a data frame to an \code{exposed_df} object if that
data frame has columns for policy numbers, statuses, exposures,
policy periods (for policy exposures only), and exposure start / end dates.
Optionally, if \code{x} has transaction counts and amounts by type, these can
be specified without calling \code{\link[=add_transactions]{add_transactions()}}.
}
