% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{gettime}
\alias{gettime}
\title{Convert time of day data to numeric}
\usage{
gettime(
  x,
  format = "\%Y-\%m-\%d \%H:\%M:\%S",
  scale = c("radian", "hour", "proportion")
)
}
\arguments{
\item{x}{A vector of POSIXct, POSIXlt or character format time data to convert.}

\item{format}{A character string defining the time/date format if \code{x} is character format, see \code{strptime} for details. Ignored if \code{x} is not character.}

\item{scale}{The scale on which to return times (see Value for options).}
}
\value{
A vector of numeric times of day in units defined by the \code{scale} argument:
radian, on the range [0, 2*pi];
hours, on the range [0, 24];
proportion, on the range [0, 1].
}
\description{
Accepts data of class POSIXct, POSIXlt or character and returns the  time of day element as numeric (any date element is ignored).
}
\examples{
data(BCItime)
rtime <- gettime(BCItime$date, "\%d/\%m/\%Y \%H:\%M")
htime <- gettime(BCItime$date, "\%d/\%m/\%Y \%H:\%M", "hour")
ptime <- gettime(BCItime$date, "\%d/\%m/\%Y \%H:\%M", "proportion")
summary(rtime)
summary(htime)
summary(ptime)
}
\seealso{
\code{\link{strptime}}
}
