% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{dvmkern}
\alias{dvmkern}
\title{Circular kernel probability density function.}
\usage{
dvmkern(x, dat, wt = NULL, bw = NULL, adj = 1)
}
\arguments{
\item{x}{Numeric vector of radian times at which to evaluate the PDF.}

\item{dat}{Numeric vector of radian time data to which the PDF is fitted.}

\item{wt}{A numeric vector of weights for each \code{dat} value.}

\item{bw}{Numeric value for kernel bandwidth.}

\item{adj}{Numeric kernel bandwidth multiplier.}
}
\value{
Numeric vector of probability densities evaluated at \code{x}.
}
\description{
Optionally weighted Von Mises kernel probability densities.
}
\details{
If \code{bw} not provided it is calculated internally using \code{bw.calc}. The \code{adj} argument is used to adjust \code{bw} to facilitate exploration of fit flexibility.
}
\examples{
#Example with made up input
tt <- runif(100,0,2*pi)
xx <- seq(0,2*pi, pi/256)
pdf <- dvmkern(xx, tt)
plot(xx, pdf, type="l")
}
\seealso{
\code{\link{bwcalc}}
}
