% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fitact}
\alias{fitact}
\title{Fit activity model to time-of-day data}
\usage{
fitact(dat, wt = NULL, reps = 1000, bw = NULL, adj = 1,
  sample = c("data", "model", "none"), show = TRUE)
}
\arguments{
\item{dat}{A numeric vector of radian time-of-day data.}

\item{wt}{A numeric vector of weights for each \code{dat} value.}

\item{reps}{Number of boostrap iterations to perform. Ignored if sample=="none".}

\item{bw}{Numeric value for kernel bandwidth. If NULL, calculated internally.}

\item{adj}{Numeric bandwidth adjustment multiplier.}

\item{sample}{Character string defining sampling method for bootstrapping errors (see details).}

\item{show}{Logical whether or not to show a progress bar while bootstrapping.}
}
\value{
An object of type \code{actmod}
}
\description{
Fits a circular kernel density to radian time-of-day data and estimates activity
level from this distribution. Optionally bootstraps the distribution, in which
case SEs and confidence limits are also stored for activity level and PDF.
}
\details{
The bandwidth adjustment multiplier \code{adj} is provided to allow
exploration of the effect of adjusting the internally calculated bandwidth on
accuracy of activity level estimates. The alternative bootstrapping methods
defined by \code{sample} are:
 \code{data}: sample from the data;
 \code{model}: sample from the fitted probability density distribution;
 \code{none}: no bootstrapping.
Confidence interval coverage seems to be better at large sample size
(greater than 100-200) using \code{"model"}, but better at small sample size
when using \code{"data"}. The reason for this  needs further investigation.
}
\examples{
#Fit without confidence limits
data(BCItime)
tdat <- 2*pi*BCItime$time[BCItime$species=="ocelot"]
mod1 <- fitact(tdat, sample="none")
plot(mod1)

#Fit with confidence limits (limited reps to speed up)
mod2 <- fitact(tdat, reps=10)
plot(mod2)

#Fit weighted function to correct for detection radius 1.21 times higher
#by day than by night, assuming day between pi/2 (6am) and pi*2/3 (6pm)
weight <- 1/ifelse(tdat>pi/2 & tdat<pi*3/2, 1.2, 1)
mod3 <- fitact(tdat, wt=weight, sample="none")
plot(mod3)
#Overplot unweighted version for comparison
plot(mod1, add=TRUE, lcol=3)
}

