% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_pro_score_cppac.R
\name{compute_pro_score_cppac}
\alias{compute_pro_score_cppac}
\title{Provide score for each question of the C-PPAC}
\usage{
compute_pro_score_cppac(
  x,
  question = c("q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12"),
  language = c("en", "fr")
)
}
\arguments{
\item{x}{A character string that is the exact response to the considered question from the C-PPAC questionnaire.}

\item{question}{A character value to identify the question to be considered when providing the score.}

\item{language}{A character value for setting the language of the considered questionnaire.}
}
\value{
A numeric value.
}
\description{
This function provides a score (from 0 to 4) in relation to the response to a given question from the C-PPAC questionnaire.
}
\examples{
compute_pro_score_cppac(
    x = "A lot (about 1 hour every day)", 
    question = "q1",
    language = "en"
    )
    
}
