% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{advEfficiency}
\alias{advEfficiency}
\title{Calculate beta estimations for efficiency}
\usage{
advEfficiency(
  x,
  labels = NULL,
  q = c(0.025, 0.5, 0.975),
  force.grid = NULL,
  paired = TRUE,
  title = ""
)
}
\arguments{
\item{x}{An efficiency object from actel (\code{overall.CJS}, \code{intra.array.CJS[[...]]} or \code{efficiency} objects)}

\item{labels}{a vector of strings to substitute default plot labels}

\item{q}{The quantile values to be calculated. Defaults to \code{c(0.025, 0.5, 0.975)} (i.e. median and 95\% CI)}

\item{force.grid}{A vector of format c(nrow, ncol) that allows the user to define the number of rows and columns to distribute the plots in.}

\item{paired}{Logical: For efficiency derived from residency analyses, should min. and max. estimates for an array be displayed next to each other?}

\item{title}{A title for the plot (feeds into title parameter of ggplot's labs function).}
}
\value{
A data frame with the required quantile values and a plot of the efficiency distributions.
}
\description{
advEfficiency estimates efficiency ranges by fitting a beta distribution
with parameters \eqn{\alpha} = number of detected tags and \eqn{\beta} = number of missed
tags. The desired quantiles (argument \code{q}) are then calculated from distribution.
Plots are also drawn showing the distribution, the median point (dashed red line) and
the range between the lowest and largest quantile requested (red shaded section).
}
\details{
Examples for inclusion in a paper:

\enumerate{
\item If advEfficiency was run on an \code{overall.CJS} object (i.e. migration analysis):

"Array efficiency was estimated by fitting a beta distribution
(\eqn{\alpha} = number of tags detected subsequently and at the array,
\eqn{\beta} = number of tags detected subsequently but not at the array)
and calculating the median estimated efficiency value using the R package actel [citation]."

\item If advEfficiency was run on an \code{efficiency} object (i.e. residency analysis):
\itemize{
\item If you are using maximum efficiency estimates:

"Array efficiency was estimated by fitting a beta distribution
(\eqn{\alpha} = number of events recorded by the array,
\eqn{\beta} = number of events known to have been missed by the array).
and calculating the median estimated efficiency value using the R package actel [citation]."
\item If you are using minimum efficiency estimates:

"Array efficiency was estimated by fitting a beta distribution
(\eqn{\alpha} = number of events recorded by the array,
\eqn{\beta} = number of events both known to have been missed and potentially missed by the array).
and calculating the median estimated efficiency value using the R package actel [citation]."
}

\item If advEfficiency was run on an \code{intra.array.CJS} object:

"Intra-array efficiency was estimated by comparing the tags detected at each of the
two replicates. For each replicate, a beta distribution was fitted
(\eqn{\alpha} = number of tags detected at both replicates, \eqn{\beta} = number
of tags detected at the opposite replicate but not at the one for which efficiency
is being calculated) and the median estimated efficiency value was calculated. The overall
efficiency of the array was then estimated as 1-((1-R1)*(1-R2)), where R1 and R2 are
the median efficiency estimates for each replicate. These calculations were performed
using the R package actel [citation]."
}
Replace [citation] with the output of \code{citation('actel')}
}
\examples{
# Example using the output of simpleCJS.
x <- matrix(
c(TRUE,  TRUE,  TRUE,  TRUE,  TRUE,
  TRUE, FALSE,  TRUE,  TRUE, FALSE,
  TRUE,  TRUE, FALSE, FALSE, FALSE,
  TRUE,  TRUE, FALSE,  TRUE,  TRUE,
  TRUE,  TRUE,  TRUE, FALSE, FALSE),
ncol = 5, byrow = TRUE)
colnames(x) <- c("Release", "A1", "A2", "A3", "A4")
cjs.results <- simpleCJS(x)

# These cjs results can be used in advEfficiency
advEfficiency(cjs.results)

# Example using the output of dualArrayCJS.
x <- matrix(
c( TRUE,  TRUE,
   TRUE, FALSE,
   TRUE,  TRUE,
  FALSE,  TRUE,
  FALSE,  TRUE),
ncol = 2, byrow = TRUE)
colnames(x) <- c("A1.1", "A1.2")
cjs.results <- dualArrayCJS(x)

# These cjs results can be used in advEfficiency
advEfficiency(cjs.results)

# advEfficiency can also be run with the output from the main analyses.
# the example.results dataset is the output of a migration analysis
advEfficiency(example.results$overall.CJS)

}
