% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{getTimes}
\alias{getTimes}
\title{Extract timestamps from the analysis results.}
\usage{
getTimes(
  input,
  locations = NULL,
  move.type = c("array", "section"),
  event.type = c("arrival", "departure"),
  n.events = c("first", "all", "last")
)
}
\arguments{
\item{input}{An actel results object generated by \code{\link{explore}}, \code{\link{migration}} or \code{\link{residency}}.}

\item{locations}{The names of the arrays or sections to be included. If left NULL, information for all arrays/sections is extracted.}

\item{move.type}{The type of events to record: one of "array" or "section".}

\item{event.type}{The point to be recorded: one of "arrival" or "departure".}

\item{n.events}{The events to record. One of "first", "all", or "last".}
}
\value{
A data frame with the timestamps for each tag (rows) and array (columns)
}
\description{
Extract timestamps from the analysis results.
}
\examples{
# using the example results loaded with actel
getTimes(example.results)

# You can specify which events to extract with 'event.type'
getTimes(example.results, event.type = "arrival")
# or
getTimes(example.results, event.type = "departure")

# and also how many events per tag.
getTimes(example.results, n.events = "first")
# or
getTimes(example.results, n.events = "all")
# or
getTimes(example.results, n.events = "last")

}
