% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_delete.R
\name{transcripts_delete}
\alias{transcripts_delete}
\title{Delete transcripts from a corpus}
\usage{
transcripts_delete(x, transcriptNames)
}
\arguments{
\item{x}{Corpus object}

\item{transcriptNames}{Vector of character strings; names of the transcript object to be deleted.}
}
\value{
Corpus object
}
\description{
Delete transcript objects from a corpus object.
You need to name the transcripts to delete directly in the parameter 'transcriptNames'.
If you want to delete transcripts based on a search pattern (regular expression) use \code{act::search_sub} first.
}
\examples{
library(act)

# delete two transcripts by their name
test <- act::transcripts_delete(examplecorpus, 
c("BOL_CCBA_SP_MeryGaby1", 
"BOL_CCBA_SP_MeryGaby2"))

# compare the the original and modified corpus object
length(examplecorpus@transcripts)
length(test@transcripts)
setdiff(names(examplecorpus@transcripts), names(test@transcripts))
test@history[length(test@history)]

# delete transcripts that match a filter, e.g. all transcripts from Bolivia "BOL_"
mymeta <- act::search_meta(examplecorpus, filterTranscriptIncludeRegEx = "BOL_")
test <- act::transcripts_delete(examplecorpus, 
mymeta$transcripts.names)

# compare the the original and modified corpus object
length(examplecorpus@transcripts)
length(test@transcripts)
setdiff(names(examplecorpus@transcripts), names(test@transcripts))
}
