% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_transcriptNames_set.R
\name{helper_transcriptNames_set}
\alias{helper_transcriptNames_set}
\title{Helper: Set names of all transcripts in a corpus}
\usage{
helper_transcriptNames_set(x, transcriptNames)
}
\arguments{
\item{x}{Corpus object}

\item{transcriptNames}{Vector of character strings; new names.}
}
\value{
List
}
\description{
Sets the names of all transcript objects in a corpus object both in the names of the list \code{x@transcripts} and in the slot \code{@name} of each transcript.
}
\examples{
library(act)

# get current names of the transcripts
names.old <- act::helper_transcriptNames_get(examplecorpus)

# rename giving numbers as names
names.test <- as.character(seq(1:length(names.old)))
test <-  act::helper_transcriptNames_set(examplecorpus, names.test)
names(test@transcripts)

# create an error: empty name
\dontrun{
names.test <- names.old
names.test[2] <- " "
test <-  act::helper_transcriptNames_set(examplecorpus, names.test)
}

# create an error: double names
\dontrun{
names.test <- names.old
names.test[2] <- names.test[1]
test <-  act::helper_transcriptNames_set(examplecorpus, names.test)
}
}
