% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus_new.R
\name{corpus_new}
\alias{corpus_new}
\title{Create a new corpus}
\usage{
corpus_new(
  corpusname,
  folders_annotationfiles,
  folders_mediafiles,
  loadFiles = TRUE
)
}
\arguments{
\item{corpusname}{Character string; name of the corpus to be created.}

\item{folders_annotationfiles}{Vector of character strings; paths to folders that contain annotation files.}

\item{folders_mediafiles}{Vector of character strings; paths to folders that contain media files.}

\item{loadFiles}{Logical; if \code{TRUE} annotation files will be loaded immediately when the function is called, if \code{FALSE} corpus object will be created without loading the annotation files.}
}
\value{
Corpus object.
}
\description{
Create a new corpus
}
\examples{
library(act)

# The example files that come with the act library are located here:
path <- system.file("extdata", "examplecorpus", package="act")

# The example corpus comes without media files.
# It is recommended to download a full example corpus also including the media files.
# You can use the following commands.
\dontrun{
   path <- "EXISTING_FOLDER_ON_YOUR_COMPUTER/examplecorpus"
   temp <- tempfile()
   download.file(options()$act.examplecorpusURL, temp)
   unzip(zipfile=temp, exdir=path)
}

# The following command creates a new corpus object
mycorpus <- act::corpus_new(corpusname = "mycorpus",
                            folders_annotationfiles = path,
                            folders_mediafiles = path)

# Get a summary
mycorpus

}
\seealso{
\link{corpus_load}, \link{examplecorpus}
}
