% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative_interval.R
\name{cumulative_interval}
\alias{cumulative_interval}
\title{Cumulative access based on maximum travel time interval}
\usage{
cumulative_interval(
  travel_matrix,
  land_use_data,
  opportunity,
  travel_cost,
  interval,
  interval_increment = 1,
  summary_function = stats::median,
  group_by = character(0),
  active = TRUE
)
}
\arguments{
\item{travel_matrix}{A data frame. The travel matrix describing the costs
(i.e. travel time, distance, monetary cost, etc.) between the origins and
destinations in the study area. Must contain the columns \code{from_id}, \code{to_id}
and any others specified in \code{travel_cost}.}

\item{land_use_data}{A data frame. The distribution of opportunities within
the study area cells. Must contain the columns \code{id} and any others
specified in \code{opportunity}.}

\item{opportunity}{A string. The name of the column in \code{land_use_data}
with the number of opportunities/resources/services to be considered when
calculating accessibility levels.}

\item{travel_cost}{A string. The name of the column in \code{travel_matrix}
with the travel cost between origins and destinations.}

\item{interval}{A \code{numeric} vector of length 2. Indicates the start and end
points of the interval of travel cost thresholds to be used. The first
entry must be lower than the second.}

\item{interval_increment}{A \code{numeric}. How many travel cost units separate
the cutoffs used to calculate the accessibility estimates which will be
used to calculate the summary estimate within the specified interval.
Should be thought as the resolution of the distribution of travel costs
within the interval. Defaults to 1.}

\item{summary_function}{A function. This function is used to summarize a
distribution of accessibility estimates within a travel cost interval as a
single value. Can be any function that takes an arbitrary number of
numeric values as as input and returns a single number as output. Defaults
to \code{\link[stats:median]{stats::median()}}.}

\item{group_by}{A \code{character} vector. When not \code{character(0)} (the default),
indicates the \code{travel_matrix} columns that should be used to group the
accessibility estimates by. For example, if \code{travel_matrix} includes a
departure time column, that specifies the departure time of each entry in
the data frame, passing \code{"departure_time"} to this parameter results in
accessibility estimates grouped by origin and by departure time.}

\item{active}{A logical. Whether to calculate active accessibility (the
of opportunities that can be reached from a given origin, the default) or
passive accessibility (by how many people each destination can be reached).}
}
\value{
A data frame containing the accessibility estimates for each
origin/destination (depending if \code{active} is \code{TRUE} or \code{FALSE}) in the
travel matrix.
}
\description{
Calculates the average or median number of opportunities that can be reached
considering multiple maximum travel cost thresholds within a given travel
cost interval specified by the user. The time interval cumulative
accessibility measures was originally proposed by
\insertCite{tomasiello2023time;textual}{accessibility}.

This function is generic over any kind of numeric travel cost,
such as distance, time and money.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data_dir <- system.file("extdata", package = "accessibility")
travel_matrix <- readRDS(file.path(data_dir, "travel_matrix.rds"))
land_use_data <- readRDS(file.path(data_dir, "land_use_data.rds"))

df <- cumulative_interval(
  travel_matrix = travel_matrix,
  land_use_data = land_use_data,
  interval = c(20, 30),
  opportunity = "schools",
  travel_cost = "travel_time"
)
head(df)

df <- cumulative_interval(
  travel_matrix = travel_matrix,
  land_use_data = land_use_data,
  interval = c(40, 80),
  opportunity = "jobs",
  travel_cost = "travel_time"
)
head(df)
\dontshow{\}) # examplesIf}
}
\references{
\insertAllCited{}
}
\seealso{
Other cumulative access: 
\code{\link{cumulative_cutoff}()}
}
\concept{cumulative access}
