% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay_power.R
\name{decay_power}
\alias{decay_power}
\title{Inverse power decay function}
\usage{
decay_power(decay_value)
}
\arguments{
\item{decay_value}{A \code{numeric} value.}
}
\value{
A \code{function} that converts travel time cost t_id into an impedance factor.
}
\description{
Returns an inverse power impedance function to be used inside
\code{accessibility} functions.
}
\examples{
library(accessibility)

# Create an inverse power impedance function
impedance <- decay_power(decay_value = 0.1)

impedance(t_ij = 20)
impedance(t_ij = 25)
impedance(t_ij = 35)

}
\seealso{
Other Impedance functions: 
\code{\link{decay_binary}()},
\code{\link{decay_exponential}()},
\code{\link{decay_linear}()}
}
\concept{Impedance functions}
