% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize training data}
\usage{
normalize(X)
}
\arguments{
\item{X}{a matrix with the training data with observations down the rows and variables in the columns.}
}
\value{
\code{normalize} Returns a list with the following attributes:
    \describe{
      \item{Xc}{The normalized data}
      \item{mx}{Mean of columns of \code{X}.}
      \item{vx}{Length of columns of \code{X}.}
      \item{Id}{Logical vector indicating which variables are
      included in X. If some of the columns have zero length they are omitted}
    }
}
\description{
Normalize a vector or matrix to zero mean and unit length columns.
}
\details{
This function can e.g. be used for the training data in the \code{ASDA} function.
}
\examples{
## Data
X<-matrix(sample(seq(3),12,replace=TRUE),nrow=3)

## Normalize data
Nm<-normalize(X)
print(Nm$Xc)

## See if any variables have been removed
which(!Nm$Id)
}
\references{
Clemmensen, L., Hastie, T. and Ersboell, K. (2008)
"Sparse discriminant analysis", Technical report, IMM, Technical University of Denmark
}
\seealso{
\code{\link{normalizetest}}, \code{\link{predict.ASDA}}, \code{\link{ASDA}}
}
\author{
Line Clemmensen
}
