% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateabn.R
\name{gauss_bugs}
\alias{gauss_bugs}
\alias{gauss_bugsGroup}
\title{Bugs code for Gaussian response}
\usage{
gauss_bugs(nodename, nodesintercept, parentnames, parentcoefs, std)

gauss_bugsGroup(
  nodename,
  nodesintercept,
  parentnames,
  parentcoefs,
  sigma,
  sigma_alpha
)
}
\arguments{
\item{nodename}{character string of response variable name.}

\item{nodesintercept}{overall mean of response. Parameter from fixed-effects intercept.}

\item{parentnames}{single character string (for one parent) or vector of characters (for multiple parent nodes) with parent node (predictor variables) names.}

\item{parentcoefs}{overall slope for each predictor (parent node) variable (fixed-effects).}

\item{std}{integer with standard deviation of response variable that will be
converted to precision (see Details).}

\item{sigma}{within-group variance. Parameter from random-effects residual.}

\item{sigma_alpha}{between-group variance. Parameter from random-effects intercept.}
}
\value{
Bugs model returned as stdout.
}
\description{
Bugs model for a normal distributed response variable
\eqn{X \sim \mathcal{N}(\mu,\,\sigma^{2})}.
}
\details{
The variance of the normal distribution is \eqn{\frac{1}{\tau}}.
}
\section{Functions}{
\itemize{
\item \code{gauss_bugsGroup()}: Bugs code for Gaussian response with varying intercept

}}
\examples{
gauss_bugs(nodename = "a",
           parentnames = c("b", "c"),
           nodesintercept = c(0.318077),
           parentcoefs = list("b"=c(b=0.3059395),
                              "c"=c(c=0.5555)),
           std = c(0.05773503))
}
\seealso{
\link{makebugs} \link{simulateAbn}
}
\keyword{internal}
\keyword{utilities}
