% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energySIM_helper.R
\name{energySIM_helper}
\alias{energySIM_helper}
\title{Run energy-dynamic based model for one replicate}
\usage{
energySIM_helper(
  sp,
  env_orig,
  env_subtract,
  days,
  sigma,
  dest_x,
  dest_y,
  mot_x,
  mot_y,
  search_radius,
  optimum_lo,
  optimum_hi,
  init_energy,
  direction,
  single_rast,
  mortality,
  energy_adj
)
}
\arguments{
\item{sp}{A species object}

\item{days}{Integer, how many days (timesteps), would you like to model}

\item{sigma}{Numeric, amount of random error}

\item{dest_x}{Numeric, destination x coordinate (longitude)}

\item{dest_y}{Numeric, destination y coordinate (latitude)}

\item{mot_x}{Numeric, movement motivation in x direction}

\item{mot_y}{Numeric, movement motivation in y direction}

\item{search_radius}{Radius of semicircle to South of current location to search for next timestep (in km)}

\item{optimum_lo}{come back}

\item{optimum_hi}{come back}

\item{init_energy}{come back}

\item{direction}{come back}

\item{mortality}{Logical, should low energy levels result in death?}

\item{env}{Raster, should represent NDVI or your environmental variable of interest}

\item{sp_poly}{Come back to this}
}
\value{
A nx3 dataset containing longitude and latitude and energy
points for all n timesteps
}
\description{
Runs agent based modeling for one replicate of a single species.
}
\keyword{internal}
