% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed2positions.R
\name{bed2positions}
\alias{bed2positions}
\title{Unwrap a list of genomic intervals into a list of loci grouped by chromosome.}
\usage{
bed2positions(targetbed, chrom_to_extract, get_only_chromosomes = FALSE)
}
\arguments{
\item{targetbed}{Genomic regions in the BED tab-delimited format.}

\item{chrom_to_extract}{The chromosome name to extract as i.e. "chr1" or "1" accordingly with BED file annotation}

\item{get_only_chromosomes}{Set TRUE to return only the list of \code{chromosomes} present in the \code{targetbed}. default: FALSE}
}
\value{
\code{PosByChrom}:  A list of data.frames (each row is a locus) one for each chromosome present in the \code{targetbed}.

\code{chromosomes}: A vector listing chromosomes present in the \code{targetbed}.
}
\description{
Unwrap a list of genomic intervals into a list of loci grouped by chromosome.
}
\examples{
targetbed <- system.file("extdata", "regions_toy.bed",package = "abemus")
chromosomes <- bed2positions(targetbed = targetbed,chrom_to_extract="8")
targetbp_list <- bed2positions(targetbed = targetbed,get_only_chromosomes = TRUE)
}
