% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processRemoteImage.R
\name{processRemoteImage}
\alias{processRemoteImage}
\title{Process Remote Image}
\usage{
processRemoteImage(img_url = NULL, language = "English",
  profile = "documentConversion", textType = "normal",
  imageSource = "auto", correctOrientation = "true", correctSkew = "true",
  readBarcodes = "false", exportFormat = "txt", description = NULL,
  pdfPassword = NULL, ...)
}
\arguments{
\item{img_url}{Required; url to remote image}

\item{language}{Optional; default: English}

\item{profile}{Optional; default: documentConversion}

\item{textType}{Optional; default: normal}

\item{imageSource}{Optional; default: auto}

\item{correctOrientation}{Optional; default: true}

\item{correctSkew}{Optional; default: true}

\item{readBarcodes}{Optional; default:}

\item{exportFormat}{Optional; default: txt}

\item{description}{Optional; default: ""}

\item{pdfPassword}{Optional; default: NULL}

\item{\dots}{Additional arguments passed to \code{\link{abbyy_GET}}.}
}
\value{
Data frame with details of the task associated with the submitted Remote Image
}
\description{
This function gets Information about a particular application
}
\examples{
\dontrun{
processRemoteImage(img_url="img_url")
}
}
\references{
\url{http://ocrsdk.com/documentation/apireference/processRemoteImage/}
}

