% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba_utils.R
\name{set_stats}
\alias{set_stats}
\title{Set the stats of an aba model}
\usage{
set_stats(.model, ..., labels = NULL)
}
\arguments{
\item{.model}{an aba model. The model on which to set stats.}

\item{...}{strings or aba stat object. Each comma-separated value will be
a different stat. If you specify a string, then the default stat params
will be used. Some stats require that you actually call them (e.g. \code{stat_lme})
because they require other parameters like \code{id} and \code{time} variables.}

\item{labels}{vector of strings. Labels for printing & plotting.}
}
\value{
An abaModel object with stats sets.
}
\description{
Stats are the objects which specify 1) how model formulas should be created
from the model specification, and 2) how to actual fit statistical models.
Stats also have their own parameters which you can specify to change how
the stat is fit. Multiple stats can be specified for an aba model. The best
way to see all the available stats is the type \code{aba::stat_} in the console
and look at the auto-completion.
}
\details{
There is a broad collection of stats implemented in aba which we plan to
add to. Please feel free to request more. Also, there are certain extra
parameters which are common to all stats. These include \code{std.beta} which
determines whether to z-score all variables prior to model fitting, and
\code{complete.cases} which determines whether to only use individuals with all
available data within each group - outcome but across all predictor sets.
}
\examples{

# create default stat object by specifying only a string
model <- aba_model() \%>\%
  set_stats('glm')

# pass an actual stat object. This is useful to specify extra params
# such as `std.beta` and `complete.cases` which is common to all stats.
model <- aba_model() \%>\%
  set_stats(
    stat_glm(std.beta = TRUE, complete.cases = FALSE)
  )

# some stats such as lme require parameters
# those variables are expected to exist in the eventual data
model <- aba_model() \%>\%
  set_stats(
    stat_lme(id = 'RID', time = 'YEARS_bl')
  )

# you can see these extra stat params when you print the model
print(model)

}
