% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_watercolors.R
\name{canvas_watercolors}
\alias{canvas_watercolors}
\title{Draw Watercolors}
\usage{
canvas_watercolors(
  colors,
  background = "#fafafa",
  layers = 50,
  depth = 2,
  resolution = 250
)
}
\arguments{
\item{colors}{a string specifying the color used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{layers}{the number of layers of each color.}

\item{depth}{the maximum depth of the recursive algorithm.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints watercolors on a canvas.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_watercolors(colors = colorPalette("tuscany2"))
}

}
\references{
\url{https://tylerxhobbs.com/essays/2017/a-generative-approach-to-simulating-watercolor-paints}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
