% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_cobweb.R
\name{canvas_cobweb}
\alias{canvas_cobweb}
\title{Draw Cobwebs}
\usage{
canvas_cobweb(colors, background = "#fafafa", lines = 300,
              iterations = 100)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{lines}{the number of lines to draw.}

\item{iterations}{the number of iterations of the algorithm.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws many Fibonacci spirals shifted by random noise from a normal distribution.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_cobweb(colors = colorPalette("neon1"), background = "black")
}

}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
