% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_mosaic.R
\name{canvas_mosaic}
\alias{canvas_mosaic}
\title{Paint a Random Mosaic on a Canvas}
\usage{
canvas_mosaic(colors, maxk = 1, n = 1000, resolution = 500)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{maxk}{a positive integer specifying the maximum number of nearest neighbors to consider.}

\item{n}{a positive integer specifying the number of random data points to generate.}

\item{resolution}{a positive integer specifying the number of pixels (resolution x resolution) of the artwork.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints a mosaic from randomly generated data by running a k-nearest neighbors classification algorithm to predict the color of each pixel on the canvas. Low values of \code{maxk} produce a mosaic like artwork, while higher values produce a more smooth decision boundary.
}
\examples{
\donttest{
set.seed(9)
palette <- colorPalette('random', n = 10)
canvas_mosaic(colors = palette)
}

}
\references{
\url{https://en.wikipedia.org/wiki/K-nearest_neighbors_algorithm}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
